/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.search.heuristic;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.StaticArea;
import gov.nasa.jpf.jvm.StaticElementInfo;
import gov.nasa.jpf.search.heuristic.SimplePriorityHeuristic;

public class UserHeuristic
extends SimplePriorityHeuristic {
    static final int defaultValue = 1000;

    public UserHeuristic(Config config, JVM vm) throws Config.Exception {
        super(config, vm);
    }

    @Override
    protected int computeHeuristicValue() {
        ElementInfo b;
        StaticArea ss = this.vm.getStaticArea();
        StaticElementInfo p = ss.get("Main");
        if (p != null && (b = p.getObjectField("buffer")) != null) {
            int current = b.getIntField("current");
            int capacity = b.getIntField("capacity");
            return capacity - current;
        }
        return 1000;
    }
}

