/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.search.heuristic;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.Transition;
import gov.nasa.jpf.search.heuristic.SimplePriorityHeuristic;

public class PreferThreads
extends SimplePriorityHeuristic {
    String[] preferredThreads;

    public PreferThreads(Config config, JVM vm) throws Config.Exception {
        super(config, vm);
        this.preferredThreads = config.getStringArray("search.heuristic.preferredThreads");
    }

    @Override
    protected int computeHeuristicValue() {
        Transition t = this.vm.getLastTransition();
        if (t == null) {
            return 1;
        }
        String tn = this.vm.getThreadName();
        for (int i = 0; i < this.preferredThreads.length; ++i) {
            if (!tn.equals(this.preferredThreads[i])) continue;
            return 0;
        }
        return 1;
    }
}

