/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.search.heuristic;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.search.Search;
import gov.nasa.jpf.search.heuristic.HeuristicState;
import java.util.ArrayList;
import java.util.List;

public abstract class HeuristicSearch
extends Search {
    static final String DEFAULT_HEURISTIC_PACKAGE = "gov.nasa.jpf.search.heuristic.";
    protected HeuristicState parentState;
    protected List<HeuristicState> childStates;
    protected boolean isPathSensitive = false;
    protected boolean useAstar;
    protected boolean isBeamSearch;

    public HeuristicSearch(Config config, JVM vm) throws Config.Exception {
        super(config, vm);
        this.useAstar = config.getBoolean("search.heuristic.astar");
        this.isBeamSearch = config.getBoolean("search.heuristic.beam_search");
    }

    protected abstract HeuristicState queueCurrentState();

    protected abstract HeuristicState getNextQueuedState();

    public abstract int getQueueSize();

    public abstract boolean isQueueLimitReached();

    public HeuristicState getParentState() {
        return this.parentState;
    }

    public List<HeuristicState> getChildStates() {
        return this.childStates;
    }

    public void setPathSensitive(boolean isPathSensitive) {
        this.isPathSensitive = isPathSensitive;
    }

    void backtrackToParent() {
        this.backtrack();
        --this.depth;
        this.notifyStateBacktracked();
    }

    protected boolean generateChildren(int maxDepth) {
        this.childStates = new ArrayList<HeuristicState>();
        while (!this.done) {
            if (!this.forward()) {
                this.notifyStateProcessed();
                return true;
            }
            ++this.depth;
            this.notifyStateAdvanced();
            if (this.hasPropertyTermination()) {
                return false;
            }
            if (!this.isEndState && !this.isIgnoredState) {
                if (this.isNewState && this.depth >= maxDepth) {
                    this.notifySearchConstraintHit("Search Depth");
                } else if (this.isNewState || this.isPathSensitive) {
                    HeuristicState newHState;
                    if (this.isQueueLimitReached()) {
                        this.notifySearchConstraintHit("Seqrch Queue Size");
                    }
                    if ((newHState = this.queueCurrentState()) != null) {
                        this.childStates.add(newHState);
                        this.notifyStateStored();
                    }
                }
            }
            this.backtrackToParent();
        }
        return false;
    }

    private void restoreState(HeuristicState hState) {
        this.vm.restoreState(hState.getVMState());
        this.depth = this.vm.getPathLength();
        this.notifyStateRestored();
    }

    @Override
    public void search() {
        int maxDepth = this.getMaxSearchDepth();
        this.queueCurrentState();
        this.notifyStateStored();
        this.parentState = this.getNextQueuedState();
        this.done = false;
        this.notifySearchStarted();
        if (!this.hasPropertyTermination()) {
            this.generateChildren(maxDepth);
            while (!this.done && (this.parentState = this.getNextQueuedState()) != null) {
                this.restoreState(this.parentState);
                this.generateChildren(maxDepth);
            }
        }
        this.notifySearchFinished();
    }
}

