/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.search;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.Error;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.Property;
import gov.nasa.jpf.State;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.Path;
import gov.nasa.jpf.jvm.ThreadList;
import gov.nasa.jpf.jvm.Transition;
import gov.nasa.jpf.search.SearchListener;
import gov.nasa.jpf.search.SearchListenerMulticaster;
import gov.nasa.jpf.search.SearchState;
import gov.nasa.jpf.util.IntVector;
import gov.nasa.jpf.util.ObjArray;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public abstract class Search {
    protected static Logger log = JPF.getLogger("gov.nasa.jpf.search");
    public static final String DEPTH_CONSTRAINT = "Search Depth";
    public static final String QUEUE_CONSTRAINT = "Seqrch Queue Size";
    public static final String FREE_MEMORY_CONSTRAINT = "Free Memory Limit";
    protected ArrayList<Error> errors = new ArrayList();
    protected int depth = 0;
    protected JVM vm;
    ArrayList<Property> properties;
    protected boolean isEndState = false;
    protected boolean isNewState = true;
    protected boolean isIgnoredState = false;
    protected boolean matchDepth;
    protected long minFreeMemory;
    protected int depthLimit;
    protected String lastSearchConstraint;
    protected boolean done = false;
    protected boolean doBacktrack = false;
    SearchListener listener;
    Config config;
    final IntVector stateDepth = new IntVector();

    protected Search(Config config, JVM vm) throws Config.Exception {
        this.vm = vm;
        this.config = config;
        this.depthLimit = config.getInt("search.depth_limit", -1);
        this.matchDepth = config.getBoolean("search.match_depth");
        this.minFreeMemory = config.getMemorySize("search.min_free", 0x100000L);
        this.properties = this.getProperties(config);
        if (this.properties.isEmpty()) {
            log.severe("no property");
        }
    }

    public Config getConfig() {
        return this.config;
    }

    public abstract void search();

    public void addProperty(Property newProperty) {
        this.properties.add(newProperty);
    }

    public void removeProperty(Property oldProperty) {
        this.properties.remove(oldProperty);
    }

    protected ArrayList<Property> getProperties(Config config) throws Config.Exception {
        Class[] argTypes = new Class[]{Config.class, Search.class};
        Object[] args = new Object[]{config, this};
        ArrayList<Property> list = new ArrayList<Property>();
        ObjArray<Property> a = config.getInstances("search.properties", Property.class, argTypes, args);
        if (a != null) {
            for (Property p : a) {
                list.add(p);
            }
        }
        return list;
    }

    protected boolean hasPropertyTermination() {
        return this.isPropertyViolated() && this.done;
    }

    boolean isPropertyViolated() {
        for (Property p : this.properties) {
            if (p.check(this, this.vm)) continue;
            this.error(p, this.vm.getClonedPath(), this.vm.getThreadList());
            return true;
        }
        return false;
    }

    public void addListener(SearchListener newListener) {
        this.listener = SearchListenerMulticaster.add(this.listener, newListener);
    }

    public boolean hasListenerOfType(Class<?> type) {
        return SearchListenerMulticaster.containsType(this.listener, type);
    }

    public void removeListener(SearchListener removeListener) {
        this.listener = SearchListenerMulticaster.remove(this.listener, removeListener);
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public String getLastSearchContraint() {
        return this.lastSearchConstraint;
    }

    public Error getLastError() {
        int i = this.errors.size() - 1;
        if (i >= 0) {
            return this.errors.get(i);
        }
        return null;
    }

    public JVM getVM() {
        return this.vm;
    }

    public boolean isEndState() {
        return this.isEndState;
    }

    public boolean hasNextState() {
        return !this.isEndState();
    }

    public boolean isNewState() {
        boolean isNew = this.vm.isNewState();
        if (this.matchDepth) {
            int id = this.vm.getStateId();
            if (isNew) {
                this.setStateDepth(id, this.depth);
            } else {
                return this.depth < this.getStateDepth(id);
            }
        }
        return isNew;
    }

    public boolean isVisitedState() {
        return !this.isNewState();
    }

    public int getDepth() {
        return this.depth;
    }

    public String getSearchConstraint() {
        return this.lastSearchConstraint;
    }

    public Transition getTransition() {
        return this.vm.getLastTransition();
    }

    public int getStateNumber() {
        return this.vm.getStateId();
    }

    public boolean requestBacktrack() {
        return false;
    }

    public boolean supportsBacktrack() {
        return false;
    }

    public boolean supportsRestoreState() {
        return false;
    }

    protected int getMaxSearchDepth() {
        int initialDepth;
        int searchDepth = Integer.MAX_VALUE;
        if (this.depthLimit > 0 && Integer.MAX_VALUE - (initialDepth = this.vm.getPathLength()) > this.depthLimit) {
            searchDepth = this.depthLimit + initialDepth;
        }
        return searchDepth;
    }

    public int getDepthLimit() {
        return this.depthLimit;
    }

    protected SearchState getSearchState() {
        return new SearchState(this);
    }

    public void error(Property property) {
        this.error(property, null, null);
    }

    protected void error(Property property, Path path, ThreadList threadList) {
        int i;
        boolean getAllErrors = this.config.getBoolean("search.multiple_errors");
        if (getAllErrors) {
            path = path.clone();
            threadList = (ThreadList)threadList.clone();
        }
        Error error = new Error(this.errors.size() + 1, property, path, threadList);
        String fname = this.config.getString("search.error_path");
        if (fname != null && getAllErrors && (i = fname.lastIndexOf(46)) >= 0) {
            fname = fname.substring(0, i) + '-' + this.errors.size() + fname.substring(i);
        }
        this.errors.add(error);
        if (getAllErrors) {
            this.done = false;
            this.isIgnoredState = true;
        } else {
            this.done = true;
        }
        this.notifyPropertyViolated();
        if (getAllErrors) {
            property.reset();
        }
    }

    protected void notifyStateAdvanced() {
        if (this.listener != null) {
            this.listener.stateAdvanced(this);
        }
    }

    protected void notifyStateProcessed() {
        if (this.listener != null) {
            this.listener.stateProcessed(this);
        }
    }

    protected void notifyStateStored() {
        if (this.listener != null) {
            this.listener.stateStored(this);
        }
    }

    protected void notifyStateRestored() {
        if (this.listener != null) {
            this.listener.stateRestored(this);
        }
    }

    protected void notifyStateBacktracked() {
        if (this.listener != null) {
            this.listener.stateBacktracked(this);
        }
    }

    protected void notifyPropertyViolated() {
        if (this.listener != null) {
            this.listener.propertyViolated(this);
        }
    }

    protected void notifySearchStarted() {
        if (this.listener != null) {
            this.listener.searchStarted(this);
        }
    }

    protected void notifySearchConstraintHit(String constraintId) {
        if (this.listener != null) {
            this.lastSearchConstraint = constraintId;
            this.listener.searchConstraintHit(this);
        }
    }

    protected void notifySearchFinished() {
        if (this.listener != null) {
            this.listener.searchFinished(this);
        }
    }

    protected boolean forward() {
        boolean ret = this.vm.forward();
        this.isNewState = ret ? this.vm.isNewState() : false;
        this.isIgnoredState = false;
        this.isEndState = this.vm.isEndState();
        return ret;
    }

    protected boolean backtrack() {
        this.isNewState = false;
        this.isEndState = false;
        this.isIgnoredState = false;
        return this.vm.backtrack();
    }

    public void setIgnoredState(boolean b) {
        this.isIgnoredState = b;
    }

    protected void restoreState(State state) {
    }

    public void terminate() {
        this.done = true;
    }

    void setStateDepth(int stateId, int depth) {
        this.stateDepth.set(stateId, depth + 1);
    }

    int getStateDepth(int stateId) {
        int depthPlusOne = this.stateDepth.get(stateId);
        if (depthPlusOne <= 0) {
            throw new JPFException("Asked for depth of unvisited state");
        }
        return depthPlusOne - 1;
    }

    boolean checkStateSpaceLimit() {
        Runtime rt = Runtime.getRuntime();
        long avail = rt.freeMemory();
        if (avail < this.minFreeMemory) {
            rt.gc();
            avail = rt.freeMemory();
            if (avail < this.minFreeMemory) {
                return false;
            }
        }
        return true;
    }
}

