/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.search;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.VMState;
import gov.nasa.jpf.search.Search;
import gov.nasa.jpf.util.Debug;

public class RandomSearch
extends Search {
    int path_limit = 0;

    public RandomSearch(Config config, JVM vm) throws Config.Exception {
        super(config, vm);
        this.path_limit = config.getInt("search.RandomSearch.path_limit", 0);
        System.out.println("Path Limit = " + this.path_limit);
        Debug.println(1, "Random Search");
    }

    @Override
    public void search() {
        int maxDepth = this.getMaxSearchDepth();
        int depth = 0;
        int paths = 0;
        ++depth;
        if (this.hasPropertyTermination()) {
            return;
        }
        VMState init_state = this.vm.getState();
        this.notifySearchStarted();
        while (!this.done) {
            if (depth < maxDepth && this.forward() && !this.isEndState) {
                this.notifyStateAdvanced();
                if (this.hasPropertyTermination()) {
                    return;
                }
                ++depth;
                continue;
            }
            if (depth >= maxDepth) {
                this.notifySearchConstraintHit("Seqrch Queue Size");
            }
            this.isPropertyViolated();
            this.done = paths >= this.path_limit;
            System.out.println("paths = " + ++paths);
            depth = 1;
            this.vm.restoreState(init_state);
            this.vm.resetNextCG();
        }
        this.notifySearchFinished();
    }
}

