/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.search;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.search.Search;

public class PathSearch
extends Search {
    public PathSearch(Config config, JVM vm) throws Config.Exception {
        super(config, vm);
    }

    @Override
    public boolean requestBacktrack() {
        this.doBacktrack = true;
        return true;
    }

    @Override
    public void search() {
        ++this.depth;
        if (this.hasPropertyTermination()) {
            return;
        }
        this.notifySearchStarted();
        while (true) {
            if (this.doBacktrack) {
                if (this.depth > 0) {
                    this.vm.backtrack();
                    --this.depth;
                    this.notifyStateBacktracked();
                }
                this.doBacktrack = false;
                continue;
            }
            this.forward();
            this.notifyStateAdvanced();
            if (this.hasPropertyTermination() || this.isEndState) break;
            ++this.depth;
        }
        this.notifySearchFinished();
    }

    @Override
    public boolean supportsBacktrack() {
        return true;
    }
}

