/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.search;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.search.Search;

public class DFSearch
extends Search {
    public DFSearch(Config config, JVM vm) throws Config.Exception {
        super(config, vm);
    }

    @Override
    public boolean requestBacktrack() {
        this.doBacktrack = true;
        return true;
    }

    @Override
    public void search() {
        int maxDepth = this.getMaxSearchDepth();
        this.depth = 0;
        this.notifySearchStarted();
        while (!this.done) {
            if (!this.isNewState || this.isEndState || this.isIgnoredState) {
                if (!this.backtrack()) break;
                --this.depth;
                this.notifyStateBacktracked();
            }
            if (this.forward()) {
                this.notifyStateAdvanced();
                if (this.hasPropertyTermination()) break;
                ++this.depth;
                if (!this.isNewState) continue;
                if (this.depth >= maxDepth) {
                    this.isEndState = true;
                    this.notifySearchConstraintHit("Search Depth: " + maxDepth);
                }
                if (this.checkStateSpaceLimit()) continue;
                this.notifySearchConstraintHit("Free Memory Limit: " + this.minFreeMemory);
                break;
            }
            this.notifyStateProcessed();
        }
        this.notifySearchFinished();
    }

    @Override
    public boolean supportsBacktrack() {
        return true;
    }
}

