/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.report;

import gov.nasa.jpf.ListenerAdapter;
import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.ThreadChoiceGenerator;
import gov.nasa.jpf.search.Search;

public class Statistics
extends ListenerAdapter
implements Cloneable {
    public long maxUsed = 0L;
    public long newStates = 0L;
    public int backtracked = 0;
    public int restored = 0;
    public int processed = 0;
    public int constraints = 0;
    public long visitedStates = 0L;
    public long endStates = 0L;
    public int maxDepth = 0;
    public int gcCycles = 0;
    public int insns = 0;
    public int threadCGs = 0;
    public int dataCGs = 0;
    public int nObjects = 0;
    public int nRecycled = 0;

    public synchronized Statistics clone() {
        try {
            return (Statistics)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public synchronized void gcBegin(JVM vm) {
        ++this.gcCycles;
    }

    @Override
    public synchronized void instructionExecuted(JVM vm) {
        ++this.insns;
    }

    @Override
    public synchronized void choiceGeneratorSet(JVM vm) {
        ChoiceGenerator cg = vm.getChoiceGenerator();
        if (cg instanceof ThreadChoiceGenerator) {
            ++this.threadCGs;
        } else {
            ++this.dataCGs;
        }
    }

    @Override
    public synchronized void objectCreated(JVM vm) {
        ++this.nObjects;
    }

    @Override
    public synchronized void objectReleased(JVM vm) {
        ++this.nRecycled;
    }

    @Override
    public synchronized void stateAdvanced(Search search) {
        long m = Runtime.getRuntime().totalMemory();
        if (m > this.maxUsed) {
            this.maxUsed = m;
        }
        if (search.isNewState()) {
            ++this.newStates;
            int depth = search.getDepth();
            if (depth > this.maxDepth) {
                this.maxDepth = depth;
            }
        } else {
            ++this.visitedStates;
        }
        if (search.isEndState()) {
            ++this.endStates;
        }
    }

    @Override
    public synchronized void stateBacktracked(Search search) {
        ++this.backtracked;
    }

    @Override
    public synchronized void stateProcessed(Search search) {
        ++this.processed;
    }

    @Override
    public synchronized void stateRestored(Search search) {
        ++this.restored;
    }

    @Override
    public synchronized void searchConstraintHit(Search search) {
        ++this.constraints;
    }
}

