/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.untracked;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.CollapsingRestorer;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.Fields;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.Monitor;
import gov.nasa.jpf.jvm.untracked.UntrackedManager;

public class UntrackedCollapsingRestorer
extends CollapsingRestorer {
    @Override
    public void attach(JVM jvm) throws Config.Exception {
        super.attach(jvm);
        boolean untrackedProp = jvm.getConfig().getBoolean("vm.untracked", false);
        UntrackedManager.setProperty(untrackedProp);
    }

    @Override
    protected void restoreFields(ElementInfo ei, Fields fields) {
        if (UntrackedManager.getProperty()) {
            UntrackedManager.getInstance().restoreTrackedFields(ei, fields);
        } else {
            ei.restoreFields(fields);
        }
    }

    @Override
    protected Fields poolFields(ElementInfo ei) {
        if (UntrackedManager.getProperty() && UntrackedManager.getInstance().isUntracked(ei)) {
            return ei.getFields();
        }
        return super.poolFields(ei);
    }

    @Override
    protected Monitor poolMonitor(ElementInfo ei) {
        if (UntrackedManager.getProperty() && UntrackedManager.getInstance().isUntracked(ei)) {
            return ei.getMonitor();
        }
        return super.poolMonitor(ei);
    }
}

