/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.untracked;

import gov.nasa.jpf.jvm.ArrayFields;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.untracked.UntrackedFields;
import gov.nasa.jpf.jvm.untracked.UntrackedManager;

public class UntrackedArrayFields
extends ArrayFields
implements UntrackedFields {
    protected int untracked;

    @Override
    public void setUntracked(int untracked) {
        this.untracked = untracked;
    }

    @Override
    public int getUntracked() {
        return this.untracked;
    }

    @Override
    public boolean isUntracked() {
        return this.untracked > 0;
    }

    @Override
    public void incUntracked() {
        ++this.untracked;
    }

    @Override
    public void decUntracked() {
        --this.untracked;
    }

    public UntrackedArrayFields(String type, ClassInfo ci, int storageSize, int length, boolean isReference) {
        super(type, ci, storageSize, length, isReference);
    }

    @Override
    public void setReferenceValue(ElementInfo ei, int index, int newValue) {
        UntrackedManager manager = null;
        if (UntrackedManager.getProperty() && this.untracked > 0) {
            manager = UntrackedManager.getInstance();
            manager.oldObjectsTraversal(this.values[index]);
        }
        this.values[index] = newValue;
        if (manager != null) {
            manager.newObjectsTraversal(newValue);
        }
    }
}

