/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.choice;

import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.util.Invocation;
import java.io.PrintWriter;
import java.util.List;
import java.util.ListIterator;

public class InvocationCG
extends ChoiceGenerator {
    List<Invocation> invokes;
    Invocation cur;
    ListIterator<Invocation> it;

    public InvocationCG(List<Invocation> invokes) {
        this.invokes = invokes;
        this.it = invokes.listIterator();
    }

    @Override
    public void advance() {
        this.cur = this.it.next();
    }

    public Class getChoiceType() {
        return Invocation.class;
    }

    public Invocation getNextChoice() {
        return this.cur;
    }

    @Override
    public int getProcessedNumberOfChoices() {
        return this.it.nextIndex();
    }

    @Override
    public int getTotalNumberOfChoices() {
        return this.invokes.size();
    }

    @Override
    public boolean hasMoreChoices() {
        return this.it.hasNext();
    }

    public ChoiceGenerator randomize() {
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append(" [");
        int n = this.invokes.size();
        for (int i = 0; i < n; ++i) {
            Invocation inv;
            if (i > 0) {
                sb.append(',');
            }
            if ((inv = this.invokes.get(i)) == this.cur) {
                sb.append('>');
            }
            sb.append(inv);
        }
        sb.append(']');
        return sb.toString();
    }

    public void printOn(PrintWriter pw) {
        pw.print(this.toString());
    }

    @Override
    public void reset() {
        this.cur = null;
        this.it = this.invokes.listIterator();
    }
}

