/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.choice;

import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.StaticElementInfo;
import gov.nasa.jpf.jvm.ThreadInfo;

public class IntSpec {
    public static int eval(String spec) {
        int ret;
        char c = spec.charAt(0);
        if (Character.isDigit(c) || c == '+' || c == '-') {
            try {
                ret = Integer.parseInt(spec);
            }
            catch (NumberFormatException nfx) {
                throw new JPFException("int literal did not parse: " + spec);
            }
        } else {
            ret = IntSpec.resolveVar(spec);
        }
        return ret;
    }

    public static int resolveVar(String name) {
        int ret;
        JVM vm = JVM.getVM();
        String[] varId = name.split("[.]+");
        switch (varId.length) {
            case 1: {
                ThreadInfo ti = ThreadInfo.getCurrentThread();
                try {
                    ret = ti.getIntLocal(varId[0]);
                }
                catch (JPFException e) {
                    int id = ti.getThis();
                    if (id >= 0) {
                        Object ei = DynamicArea.getHeap().get(id);
                        ret = ((ElementInfo)ei).getIntField(varId[0]);
                        break;
                    }
                    ClassInfo ci = ti.getMethod().getClassInfo();
                    StaticElementInfo ei = vm.getKernelState().sa.get(ci.getName());
                    ret = ei.getIntField(varId[0]);
                }
                break;
            }
            case 2: {
                ClassInfo ci = ClassInfo.getClassInfo(varId[0]);
                StaticElementInfo ei = vm.getKernelState().sa.get(ci.getName());
                ret = ei.getIntField(varId[1]);
                break;
            }
            default: {
                throw new JPFException("Choice value format error parsing \"" + name + "\"");
            }
        }
        return ret;
    }
}

