/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.choice;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.IntChoiceGenerator;
import gov.nasa.jpf.jvm.choice.IntSpec;

public class IntChoiceFromSet
extends IntChoiceGenerator {
    String[] values;
    int count = -1;

    public IntChoiceFromSet(Config conf, String id) {
        super(id);
        this.values = conf.getStringArray(id + ".values");
        if (this.values == null) {
            throw new JPFException("value set for <" + id + "> choice did not load");
        }
    }

    protected IntChoiceFromSet(String id) {
        super(id);
    }

    @Override
    public void reset() {
        this.count = -1;
    }

    @Override
    public Integer getNextChoice() {
        int ret = IntSpec.eval(this.values[this.count]);
        return new Integer(ret);
    }

    @Override
    public boolean hasMoreChoices() {
        return !this.isDone && this.count < this.values.length - 1;
    }

    @Override
    public void advance() {
        if (this.count < this.values.length - 1) {
            ++this.count;
        }
    }

    public String getValueLabel() {
        return this.values[this.count];
    }

    @Override
    public int getTotalNumberOfChoices() {
        return this.values.length;
    }

    @Override
    public int getProcessedNumberOfChoices() {
        return this.count + 1;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("[id=\"");
        sb.append(this.id);
        sb.append("\",");
        for (int i = 0; i < this.values.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            if (i == this.count) {
                sb.append('>');
            }
            sb.append(this.values[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public IntChoiceFromSet randomize() {
        for (int i = this.values.length - 1; i > 0; --i) {
            int j = random.nextInt(i + 1);
            String tmp = this.values[i];
            this.values[i] = this.values[j];
            this.values[j] = tmp;
        }
        return this;
    }
}

