/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.choice;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.DoubleChoiceGenerator;
import gov.nasa.jpf.jvm.choice.DoubleSpec;
import java.util.logging.Logger;

public class DoubleChoiceFromSet
extends DoubleChoiceGenerator {
    static Logger log = JPF.getLogger("gov.nasa.jpf.jvm.choice");
    String[] values;
    int count;

    public DoubleChoiceFromSet(Config conf, String id) {
        super(id);
        this.values = conf.getStringArray(id + ".values");
        if (this.values == null) {
            throw new JPFException("value set for <" + id + "> choice did not load");
        }
        this.count = -1;
    }

    @Override
    public void reset() {
        this.count = -1;
    }

    @Override
    public Double getNextChoice() {
        if (this.count >= 0 && this.count < this.values.length) {
            return new Double(DoubleSpec.eval(this.values[this.count]));
        }
        return Double.NaN;
    }

    @Override
    public boolean hasMoreChoices() {
        return !this.isDone && this.count < this.values.length - 1;
    }

    @Override
    public void advance() {
        if (this.count < this.values.length - 1) {
            ++this.count;
        }
    }

    @Override
    public int getTotalNumberOfChoices() {
        return this.values.length;
    }

    @Override
    public int getProcessedNumberOfChoices() {
        return this.count + 1;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[id=\"");
        sb.append(this.id);
        sb.append("\",");
        for (int i = 0; i < this.values.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            if (i == this.count) {
                sb.append('>');
            }
            sb.append(this.values[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public DoubleChoiceFromSet randomize() {
        for (int i = this.values.length - 1; i > 0; --i) {
            int j = random.nextInt(i + 1);
            String tmp = this.values[i];
            this.values[i] = this.values[j];
            this.values[j] = tmp;
        }
        return this;
    }
}

