/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.choice;

import gov.nasa.jpf.jvm.ChoiceGenerator;

public class CustomBooleanChoiceGenerator
extends ChoiceGenerator<Boolean> {
    final boolean falseFirst;
    int count = -1;

    public CustomBooleanChoiceGenerator(boolean falseFirst, String id) {
        super(id);
        this.falseFirst = falseFirst;
    }

    @Override
    public boolean hasMoreChoices() {
        return !this.isDone && this.count < 1;
    }

    @Override
    public Boolean getNextChoice() {
        return this.falseFirst ^ this.count == 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Class<Boolean> getChoiceType() {
        return Boolean.class;
    }

    @Override
    public void advance() {
        if (this.count < 1) {
            ++this.count;
        }
    }

    @Override
    public void reset() {
        this.count = -1;
    }

    @Override
    public int getTotalNumberOfChoices() {
        return 2;
    }

    @Override
    public int getProcessedNumberOfChoices() {
        return this.count + 1;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append('[');
        boolean next = this.falseFirst ^ this.count == 0;
        if (this.count < 1) {
            sb.append('>');
            sb.append(next);
            sb.append(',');
            sb.append(!next);
        } else {
            sb.append(!next);
            sb.append(',');
            sb.append('>');
            sb.append(next);
        }
        sb.append(']');
        return sb.toString();
    }

    public CustomBooleanChoiceGenerator randomize() {
        return new CustomBooleanChoiceGenerator(random.nextBoolean(), this.id);
    }
}

