/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.choice;

import gov.nasa.jpf.jvm.ThreadChoiceGenerator;
import gov.nasa.jpf.jvm.ThreadInfo;
import java.io.PrintWriter;

public class BreakGenerator
extends ThreadChoiceGenerator {
    ThreadInfo ti;
    int state = -1;
    boolean isTerminator;

    public BreakGenerator(ThreadInfo ti, boolean isTerminator) {
        super(true);
        this.ti = ti;
        this.isTerminator = isTerminator;
    }

    @Override
    public ThreadInfo getNextChoice() {
        assert (!this.isTerminator) : "illegal operation on terminal BreakGenerator";
        return this.state == 0 ? this.ti : null;
    }

    @Override
    public void printOn(PrintWriter pw) {
        pw.println("BreakGenerator {" + this.ti.getName() + "}");
    }

    @Override
    public void advance() {
        assert (!this.isTerminator) : "illegal operation on terminal BreakGenerator";
        ++this.state;
    }

    @Override
    public int getProcessedNumberOfChoices() {
        return this.state >= 0 ? 1 : 0;
    }

    @Override
    public int getTotalNumberOfChoices() {
        return 1;
    }

    @Override
    public boolean hasMoreChoices() {
        if (this.isTerminator) {
            return false;
        }
        return this.state < 0;
    }

    @Override
    public void reset() {
        this.state = -1;
    }
}

