/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.FieldInstruction;

public abstract class StaticFieldInstruction
extends FieldInstruction {
    @Override
    public FieldInfo getFieldInfo() {
        ClassInfo ci;
        if (this.fi == null && (ci = ClassInfo.getClassInfo(this.className)) != null) {
            this.fi = ci.getStaticField(this.fname);
        }
        return this.fi;
    }

    @Override
    public ElementInfo peekElementInfo(ThreadInfo ti) {
        return this.getLastElementInfo();
    }

    @Override
    public ElementInfo getLastElementInfo() {
        return this.getFieldInfo().getClassInfo().getStaticElementInfo();
    }

    protected boolean isNewPorFieldBoundary(ThreadInfo ti) {
        return !ti.isFirstStepInsn() && ti.usePorFieldBoundaries() && this.isSchedulingRelevant(ti);
    }

    protected boolean isSchedulingRelevant(ThreadInfo ti) {
        if (this.fi.neverBreak()) {
            return false;
        }
        if (!ti.hasOtherRunnables()) {
            return false;
        }
        if (ti.usePorSyncDetection()) {
            FieldInfo fi = this.getFieldInfo();
            if (fi.breakShared()) {
                return true;
            }
            if (skipFinals && fi.isFinal()) {
                return false;
            }
            if (this.mi.isClinit() && fi.getClassInfo() == this.mi.getClassInfo()) {
                return false;
            }
            if (this.isMonitorEnterPrologue()) {
                return false;
            }
            if (this.isLockProtected(ti, fi.getClassInfo().getStaticElementInfo())) {
                return false;
            }
        }
        return true;
    }
}

