/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.StackFrame;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;

public abstract class ReturnInstruction
extends Instruction {
    StackFrame returnFrame;

    protected abstract void storeReturnValue(ThreadInfo var1);

    protected abstract void pushReturnValue(ThreadInfo var1);

    public abstract Object getReturnValue(ThreadInfo var1);

    public StackFrame getReturnFrame() {
        return this.returnFrame;
    }

    public Object getReturnAttr(ThreadInfo ti) {
        return ti.getOperandAttr();
    }

    public void setReturnAttr(ThreadInfo ti, Object attr) {
        if (attr != null) {
            ti.setOperandAttrNoClone(attr);
        }
    }

    @Override
    public Instruction execute(SystemState ss, KernelState ks, ThreadInfo ti) {
        if (!ti.isFirstStepInsn()) {
            this.mi.leave(ti);
            if (this.mi.isSynchronized()) {
                int objref = ti.getThis();
                Object ei = ks.da.get(objref);
                ChoiceGenerator<ThreadInfo> cg = ss.getSchedulerFactory().createSyncMethodExitCG((ElementInfo)ei, ti);
                if (cg != null) {
                    ss.setNextChoiceGenerator(cg);
                    ti.skipInstructionLogging();
                    return this;
                }
            }
        }
        Object attr = this.getReturnAttr(ti);
        this.storeReturnValue(ti);
        this.returnFrame = ti.getTopFrame();
        if (ti.getStackDepth() == 1) {
            int objref = ti.getThreadObjectRef();
            Object ei = ks.da.get(objref);
            if (!((ElementInfo)ei).canLock(ti)) {
                ((ElementInfo)ei).block(ti);
                ChoiceGenerator<ThreadInfo> cg = ss.getSchedulerFactory().createMonitorEnterCG((ElementInfo)ei, ti);
                if (cg != null) {
                    ss.setNextChoiceGenerator(cg);
                }
                return this;
            }
            ((ElementInfo)ei).lock(ti);
            ((ElementInfo)ei).notifiesAll();
            ((ElementInfo)ei).unlock(ti);
            ti.finish();
            ChoiceGenerator<ThreadInfo> cg = ss.getSchedulerFactory().createThreadTerminateCG(ti);
            if (cg != null) {
                ss.clearAtomic();
                ss.setNextChoiceGenerator(cg);
            }
            ti.popFrame();
            return null;
        }
        ti.popFrame();
        Instruction nextPC = ti.getReturnFollowOnPC();
        if (nextPC != ti.getPC()) {
            ti.removeArguments(this.mi);
            this.pushReturnValue(ti);
            if (attr != null) {
                this.setReturnAttr(ti, attr);
            }
        }
        return nextPC;
    }
}

