/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.InstanceFieldInstruction;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.StoreInstruction;

public class PUTFIELD
extends InstanceFieldInstruction
implements StoreInstruction {
    long lastValue;

    public long getLastValue() {
        return this.lastValue;
    }

    @Override
    public Instruction execute(SystemState ss, KernelState ks, ThreadInfo ti) {
        int objRef;
        FieldInfo fi = this.getFieldInfo();
        int storageSize = fi.getStorageSize();
        this.lastThis = objRef = ti.peek(storageSize == 1 ? 1 : 2);
        if (objRef == -1) {
            return ti.createAndThrowException("java.lang.NullPointerException", "referencing field '" + this.fname + "' on null object");
        }
        Object ei = DynamicArea.getHeap().get(objRef);
        if (this.isNewPorFieldBoundary(ti, fi, objRef) && this.createAndSetFieldCG(ss, (ElementInfo)ei, ti)) {
            return this;
        }
        Object attr = null;
        switch (storageSize) {
            case 1: {
                attr = ti.getOperandAttr();
                int ival = ti.pop();
                this.lastValue = ival;
                if (fi.isReference()) {
                    ((ElementInfo)ei).setReferenceField(fi, ival);
                    break;
                }
                ((ElementInfo)ei).setIntField(fi, ival);
                break;
            }
            case 2: {
                long lval;
                attr = ti.getLongOperandAttr();
                this.lastValue = lval = ti.longPop();
                ((ElementInfo)ei).setLongField(fi, lval);
                break;
            }
            default: {
                throw new JPFException("invalid field type");
            }
        }
        ((ElementInfo)ei).setFieldAttrNoClone(fi, attr);
        ti.pop();
        this.lastThis = objRef;
        return this.getNext(ti);
    }

    @Override
    public ElementInfo peekElementInfo(ThreadInfo ti) {
        FieldInfo fi = this.getFieldInfo();
        int storageSize = fi.getStorageSize();
        int objRef = ti.peek(storageSize == 1 ? 1 : 2);
        Object ei = DynamicArea.getHeap().get(objRef);
        return ei;
    }

    @Override
    public int getLength() {
        return 3;
    }

    @Override
    public int getByteCode() {
        return 181;
    }
}

