/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.ReturnInstruction;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.generic.Instruction;

public class LRETURN
extends ReturnInstruction {
    long ret;

    @Override
    public Object getReturnAttr(ThreadInfo ti) {
        return ti.getLongOperandAttr();
    }

    @Override
    public void setReturnAttr(ThreadInfo ti, Object attr) {
        ti.setLongOperandAttrNoClone(attr);
    }

    @Override
    public void setPeer(Instruction i, ConstantPool cp) {
    }

    @Override
    protected void storeReturnValue(ThreadInfo th) {
        this.ret = th.longPop();
    }

    @Override
    protected void pushReturnValue(ThreadInfo th) {
        th.longPush(this.ret);
    }

    public long getReturnValue() {
        return this.ret;
    }

    @Override
    public Object getReturnValue(ThreadInfo ti) {
        if (!this.isCompleted(ti)) {
            this.ret = ti.longPeek();
        }
        return new Long(this.ret);
    }

    @Override
    public int getByteCode() {
        return 173;
    }

    @Override
    public String toString() {
        return "lreturn " + this.mi.getFullName();
    }
}

