/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.Types;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Type;

public class LDC2_W
extends Instruction {
    protected Type type;
    protected long value;

    @Override
    public void setPeer(org.apache.bcel.generic.Instruction insn, ConstantPool cp) {
        ConstantPoolGen cpg = ClassInfo.getConstantPoolGen(cp);
        org.apache.bcel.generic.LDC2_W ldc2_w = (org.apache.bcel.generic.LDC2_W)insn;
        int index = ldc2_w.getIndex();
        this.type = ldc2_w.getType(cpg);
        this.value = this.type == Type.LONG ? ((ConstantLong)cp.getConstant(index)).getBytes() : Types.doubleToLong(((ConstantDouble)cp.getConstant(index)).getBytes());
    }

    @Override
    public Instruction execute(SystemState ss, KernelState ks, ThreadInfo th) {
        th.longPush(this.value);
        return this.getNext(th);
    }

    @Override
    public int getLength() {
        return 3;
    }

    @Override
    public int getByteCode() {
        return 20;
    }

    public Type getType() {
        return this.type;
    }

    public long getValue() {
        return this.value;
    }
}

