/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.Types;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Type;

public class LDC
extends Instruction {
    protected String string;
    protected int value;
    protected Type type;

    @Override
    public void setPeer(org.apache.bcel.generic.Instruction insn, ConstantPool cp) {
        ConstantPoolGen cpg = ClassInfo.getConstantPoolGen(cp);
        org.apache.bcel.generic.LDC ldc = (org.apache.bcel.generic.LDC)insn;
        this.type = ldc.getType(cpg);
        int index = ldc.getIndex();
        if (this.type == Type.STRING) {
            this.string = cp.constantToString(cp.getConstant(((ConstantString)cp.getConstant(index)).getStringIndex()));
        } else if (this.type == Type.INT) {
            this.value = ((ConstantInteger)cp.getConstant(index)).getBytes();
        } else if (this.type == Type.FLOAT) {
            this.value = Types.floatToInt(((ConstantFloat)cp.getConstant(index)).getBytes());
        } else if (this.type == Type.CLASS) {
            this.string = cp.constantToString(index, (byte)7);
        } else {
            throw new JPFException("invalid type of constant");
        }
    }

    @Override
    public Instruction execute(SystemState ss, KernelState ks, ThreadInfo ti) {
        if (this.type == Type.STRING) {
            this.value = DynamicArea.getHeap().newInternString(this.string, ti);
            ti.push(this.value, true);
        } else if (this.type == Type.CLASS) {
            ClassInfo ci = ClassInfo.getClassInfo(this.string);
            if (!ci.isInitialized() && ci.loadAndInitialize(ti, this) > 0) {
                return ti.getPC();
            }
            ti.push(ci.getClassObjectRef(), true);
        } else {
            ti.push(this.value, false);
        }
        return this.getNext(ti);
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public int getByteCode() {
        return 18;
    }

    public int getValue() {
        return this.value;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isString() {
        return this.type == Type.STRING;
    }

    public String getStringValue() {
        if (this.type == Type.STRING) {
            return this.string;
        }
        return null;
    }
}

