/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.util.Source;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.generic.InstructionHandle;

public abstract class Instruction {
    protected static final List<String> unimplemented = new ArrayList<String>();
    protected int position;
    protected int offset;
    protected MethodInfo mi;
    protected String asString;

    public abstract int getByteCode();

    public void setContext(String className, String methodName, int lineNumber, int offset) {
    }

    public boolean isFirstInstruction() {
        return this.offset == 0;
    }

    public boolean isBackJump() {
        return false;
    }

    public boolean isDeterministic(SystemState ss, KernelState ks, ThreadInfo ti) {
        return true;
    }

    public boolean isExtendedInstruction() {
        return false;
    }

    public boolean isExecutable(SystemState ss, KernelState ks, ThreadInfo th) {
        return true;
    }

    public MethodInfo getMethodInfo() {
        return this.mi;
    }

    public void setMethodInfo(MethodInfo mi) {
        this.mi = mi;
    }

    public Instruction getNext() {
        return this.mi.getInstruction(this.offset + 1);
    }

    public int getOffset() {
        return this.offset;
    }

    public int getPosition() {
        return this.position;
    }

    public void setLocation(int off, int pos) {
        this.offset = off;
        this.position = pos;
    }

    public int getLength() {
        return 1;
    }

    public Instruction getPrev() {
        if (this.offset > 0) {
            return this.mi.getInstruction(this.offset - 1);
        }
        return null;
    }

    public boolean isCompleted(ThreadInfo ti) {
        if (ti.getPC() == this) {
            return false;
        }
        if (ti.isTerminated()) {
            return true;
        }
        if (ti.getTopFrame().getMethodInfo() == this.mi) {
            return true;
        }
        return ti.getStackFrameExecuting(this) == null;
    }

    public boolean isSchedulingRelevant(SystemState ss, KernelState ks, ThreadInfo ti) {
        return false;
    }

    public abstract Instruction execute(SystemState var1, KernelState var2, ThreadInfo var3);

    public boolean examine(SystemState ss, KernelState ks, ThreadInfo th) {
        return false;
    }

    public boolean examineAbstraction(SystemState ss, KernelState ks, ThreadInfo th) {
        return false;
    }

    public String toString() {
        if (this.asString == null) {
            this.asString = this.getMnemonic();
        }
        return this.asString;
    }

    public String getMnemonic() {
        String s = this.getClass().getSimpleName();
        return s.toLowerCase();
    }

    public int getLineNumber() {
        return this.mi.getLineNumber(this);
    }

    public String getSourceLine() {
        ClassInfo ci = this.mi.getClassInfo();
        if (ci != null) {
            String srcLine;
            int line = this.mi.getLineNumber(this);
            String file = ci.getSourceFileName();
            Source src = Source.getSource(file);
            if (src != null && (srcLine = src.getLine(line)) != null) {
                return srcLine;
            }
            return "(" + file + ":" + line + ")";
        }
        return "[synthetic] " + this.mi.getName();
    }

    public String getFileLocation() {
        ClassInfo ci = this.mi.getClassInfo();
        if (ci != null) {
            int line = this.mi.getLineNumber(this);
            String fname = ci.getSourceFileName();
            return fname + ":" + line;
        }
        return "[synthetic] " + this.mi.getName();
    }

    public String getFilePos() {
        ClassInfo ci = this.mi.getClassInfo();
        int line = this.mi.getLineNumber(this);
        String file = ci.getSourceFileName();
        int i = file.lastIndexOf(File.separatorChar);
        if (i >= 0) {
            file = file.substring(i + 1);
        }
        if (file != null) {
            return file + ':' + line;
        }
        return "pc " + this.position;
    }

    public String getSourceLocation() {
        ClassInfo ci = this.mi.getClassInfo();
        String s = ci.getName() + '.' + this.mi.getName() + '(' + this.getFilePos() + ')';
        return s;
    }

    protected abstract void setPeer(org.apache.bcel.generic.Instruction var1, ConstantPool var2);

    public void init(InstructionHandle h, int off, MethodInfo m, ConstantPool cp) {
        this.position = h.getPosition();
        this.offset = off;
        this.mi = m;
        this.setPeer(h.getInstruction(), cp);
    }

    public boolean requiresClinitCalls(ThreadInfo ti, ClassInfo ci) {
        return !ti.isResumedInstruction(this) && !ci.isInitialized() && ci.loadAndInitialize(ti, this) > 0;
    }

    public Instruction getNext(ThreadInfo th) {
        return th.getPC().getNext();
    }
}

