/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.jvm.BooleanChoiceGenerator;
import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.generic.BranchInstruction;

public abstract class IfInstruction
extends Instruction {
    protected int targetPosition;
    protected Instruction target;
    protected boolean conditionValue;

    public boolean getConditionValue() {
        return this.conditionValue;
    }

    @Override
    public void setPeer(org.apache.bcel.generic.Instruction insn, ConstantPool cp) {
        this.targetPosition = ((BranchInstruction)insn).getTarget().getPosition();
    }

    public abstract boolean popConditionValue(ThreadInfo var1);

    public Instruction getTarget() {
        if (this.target == null) {
            this.target = this.mi.getInstructionAt(this.targetPosition);
        }
        return this.target;
    }

    @Override
    public Instruction execute(SystemState ss, KernelState ks, ThreadInfo ti) {
        this.conditionValue = this.popConditionValue(ti);
        if (this.conditionValue) {
            return this.getTarget();
        }
        return this.getNext(ti);
    }

    protected Instruction executeBothBranches(SystemState ss, KernelState ks, ThreadInfo ti) {
        if (!ti.isFirstStepInsn()) {
            BooleanChoiceGenerator cg = new BooleanChoiceGenerator(ti.getVM().getConfig(), this.mi.getName() + this.getClass().getSimpleName());
            ss.setNextChoiceGenerator(cg);
            return this;
        }
        ChoiceGenerator<?> cg = ss.getChoiceGenerator();
        assert (cg != null && cg instanceof BooleanChoiceGenerator) : "expected BooleanChoiceGenerator, got: " + cg;
        this.popConditionValue(ti);
        this.conditionValue = ((BooleanChoiceGenerator)cg).getNextChoice();
        if (this.conditionValue) {
            return this.getTarget();
        }
        return this.getNext(ti);
    }

    @Override
    public String toString() {
        if (this.asString == null) {
            this.asString = this.getMnemonic() + " " + this.getTarget().getOffset();
        }
        return this.asString;
    }

    @Override
    public int getLength() {
        return 3;
    }
}

