/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.InvokeInstruction;

public class INVOKESPECIAL
extends InvokeInstruction {
    @Override
    public int getByteCode() {
        return 183;
    }

    @Override
    public Instruction execute(SystemState ss, KernelState ks, ThreadInfo ti) {
        ChoiceGenerator<?> cg;
        int objRef = ti.getCalleeThis(this.getArgSize());
        MethodInfo mi = this.getInvokedMethod(ti);
        if (mi == null) {
            return ti.createAndThrowException("java.lang.NoSuchMethodException", "calling " + this.cname + "." + this.mname);
        }
        if (mi.isSynchronized() && (cg = this.getSyncCG(objRef, mi, ss, ks, ti)) != null) {
            ss.setNextChoiceGenerator(cg);
            return this;
        }
        return mi.execute(ti);
    }

    int getCalleeThis(ThreadInfo ti) {
        return ti.getCalleeThis(this.getArgSize());
    }

    @Override
    public MethodInfo getInvokedMethod(ThreadInfo th) {
        if (this.invokedMethod == null) {
            ClassInfo ci = ClassInfo.getClassInfo(this.cname);
            this.invokedMethod = ci.getMethod(this.mname, true);
        }
        return this.invokedMethod;
    }

    @Override
    public String toString() {
        MethodInfo callee = this.getInvokedMethod();
        return "invokespecial " + (callee != null ? callee.getFullName() : "?");
    }

    @Override
    public Object getFieldValue(String id, ThreadInfo ti) {
        int objRef = this.getCalleeThis(ti);
        Object ei = ti.getVM().getDynamicArea().get(objRef);
        Object v = ((ElementInfo)ei).getFieldValueObject(id);
        if (v == null) {
            v = ((ElementInfo)ei).getClassInfo().getStaticFieldValueObject(id);
        }
        return v;
    }
}

