/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.INVOKESTATIC;
import gov.nasa.jpf.jvm.bytecode.Instruction;

public class INVOKECLINIT
extends INVOKESTATIC {
    @Override
    public Instruction execute(SystemState ss, KernelState ks, ThreadInfo ti) {
        MethodInfo callee = this.getInvokedMethod(ti);
        ClassInfo ci = callee.getClassInfo();
        DynamicArea da = ti.getVM().getDynamicArea();
        Object ei = da.get(ci.getClassObjectRef());
        if (!ti.isFirstStepInsn()) {
            ChoiceGenerator<ThreadInfo> cg;
            if (!((ElementInfo)ei).canLock(ti)) {
                ((ElementInfo)ei).block(ti);
            }
            if ((cg = ss.getSchedulerFactory().createSyncMethodEnterCG((ElementInfo)ei, ti)) != null) {
                if (!ti.isBlocked()) {
                    ((ElementInfo)ei).registerLockContender(ti);
                }
                ss.setNextChoiceGenerator(cg);
                return this;
            }
            assert (!ti.isBlocked()) : "scheduling policy did not return ChoiceGenerator for blocking INVOKE";
        } else if (!ci.needsInitialization()) {
            ((ElementInfo)ei).unregisterLockContender(ti);
            return this.getNext();
        }
        return callee.execute(ti);
    }

    @Override
    public boolean isExtendedInstruction() {
        return true;
    }

    @Override
    public int getByteCode() {
        return 256;
    }
}

