/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.InstructionFactory;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.Ref;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.Types;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.InvokeInstruction;
import gov.nasa.jpf.jvm.choice.InvocationCG;
import gov.nasa.jpf.util.Invocation;
import java.util.List;
import org.apache.bcel.classfile.ConstantPool;

public class INVOKECG
extends Instruction {
    List<Invocation> invokes;
    InvokeInstruction realInvoke;

    @Override
    public void setPeer(org.apache.bcel.generic.Instruction i, ConstantPool cp) {
    }

    public void initialize(List<Invocation> invokes) {
        this.invokes = invokes;
    }

    @Override
    public Instruction execute(SystemState ss, KernelState ks, ThreadInfo ti) {
        if (!ti.isFirstStepInsn()) {
            InvocationCG cg = new InvocationCG(this.invokes);
            ss.setNextChoiceGenerator(cg);
            return this;
        }
        ChoiceGenerator<?> cg = ss.getChoiceGenerator();
        assert (cg != null && cg instanceof InvocationCG) : "expected InvocationCG, got: " + cg;
        Invocation call = ((InvocationCG)cg).getNextChoice();
        MethodInfo callee = call.getMethodInfo();
        InstructionFactory insnFactory = MethodInfo.getInstructionFactory();
        this.realInvoke = callee.isStatic() ? (InvokeInstruction)insnFactory.create(null, "INVOKESTATIC") : (InvokeInstruction)insnFactory.create(null, "INVOKEVIRTUAL");
        this.realInvoke.initialize(this.mi, callee.getClassInfo().getName(), callee.getName(), callee.getSignature(), this.offset, this.position);
        this.pushArguments(ti, call.getArguments(), call.getAttrs());
        return this.realInvoke;
    }

    void pushArguments(ThreadInfo ti, Object[] args, Object[] attrs) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                Object a = args[i];
                boolean isLong = false;
                if (a != null) {
                    if (a instanceof Ref) {
                        ti.push(((Ref)a).getReference(), true);
                    } else if (a instanceof Boolean) {
                        ti.push((Boolean)a != false ? 1 : 0, false);
                    } else if (a instanceof Integer) {
                        ti.push((Integer)a, false);
                    } else if (a instanceof Long) {
                        ti.longPush((Long)a);
                        isLong = true;
                    } else if (a instanceof Double) {
                        ti.longPush(Types.doubleToLong((Double)a));
                        isLong = true;
                    } else if (a instanceof Byte) {
                        ti.push(((Byte)a).byteValue(), false);
                    } else if (a instanceof Short) {
                        ti.push(((Short)a).shortValue(), false);
                    } else if (a instanceof Float) {
                        ti.push(Types.floatToInt(((Float)a).floatValue()), false);
                    }
                }
                if (attrs == null || attrs[i] == null) continue;
                if (isLong) {
                    ti.setLongOperandAttr(attrs[i]);
                    continue;
                }
                ti.setOperandAttr(attrs[i]);
            }
        }
    }

    @Override
    public boolean isExtendedInstruction() {
        return true;
    }

    @Override
    public int getByteCode() {
        return 258;
    }
}

