/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.jvm.DynamicElementInfo;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import org.apache.bcel.classfile.ConstantPool;

public class INSTANCEOF
extends Instruction {
    private String type;

    @Override
    public void setPeer(org.apache.bcel.generic.Instruction i, ConstantPool cp) {
        this.type = cp.constantToString(cp.getConstant(((org.apache.bcel.generic.INSTANCEOF)i).getIndex())).replace('.', '/');
        if (!this.type.startsWith("[")) {
            this.type = "L" + this.type + ";";
        }
    }

    @Override
    public Instruction execute(SystemState ss, KernelState ks, ThreadInfo th) {
        int objref = th.pop();
        if (objref == -1) {
            th.push(0, false);
        } else if (((DynamicElementInfo)ks.da.get(objref)).instanceOf(this.type)) {
            th.push(1, false);
        } else {
            th.push(0, false);
        }
        return this.getNext(th);
    }

    @Override
    public int getLength() {
        return 3;
    }

    @Override
    public int getByteCode() {
        return 193;
    }
}

