/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.LocalVariableInstruction;

public class ILOAD
extends LocalVariableInstruction {
    @Override
    public Instruction execute(SystemState ss, KernelState ks, ThreadInfo th) {
        th.pushLocal(this.index);
        return this.getNext(th);
    }

    @Override
    public int getLength() {
        if (this.index > 3) {
            return 2;
        }
        return 1;
    }

    @Override
    public int getByteCode() {
        switch (this.index) {
            case 0: {
                return 26;
            }
            case 1: {
                return 27;
            }
            case 2: {
                return 28;
            }
            case 3: {
                return 29;
            }
        }
        return 21;
    }

    @Override
    public String getMnemonic() {
        String mnemonic = "iload";
        if (this.index >= 0) {
            return mnemonic + '_' + this.index;
        }
        return mnemonic;
    }
}

