/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.StaticElementInfo;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.StaticFieldInstruction;

public class GETSTATIC
extends StaticFieldInstruction {
    @Override
    public Instruction execute(SystemState ss, KernelState ks, ThreadInfo ti) {
        FieldInfo fi = this.getFieldInfo();
        if (fi == null) {
            return ti.createAndThrowException("java.lang.NoSuchFieldException", this.className + '.' + this.fname);
        }
        ClassInfo ci = fi.getClassInfo();
        if (!this.mi.isClinit(ci) && this.requiresClinitCalls(ti, ci)) {
            return ti.getPC();
        }
        StaticElementInfo ei = ks.sa.get(ci.getName());
        if (this.isNewPorFieldBoundary(ti) && this.createAndSetFieldCG(ss, ei, ti)) {
            return this;
        }
        switch (this.size) {
            case 1: {
                int ival = ei.getIntField(fi);
                ti.push(ival, fi.isReference());
                break;
            }
            case 2: {
                long lval = ei.getLongField(fi);
                ti.longPush(lval);
                break;
            }
            default: {
                throw new JPFException("invalid field type");
            }
        }
        Object attr = ei.getFieldAttr(fi);
        if (attr != null) {
            ti.setOperandAttrNoClone(attr);
        }
        return this.getNext(ti);
    }

    @Override
    public int getLength() {
        return 3;
    }

    @Override
    public int getByteCode() {
        return 178;
    }
}

