/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.FieldLockInfo;
import gov.nasa.jpf.jvm.FieldLockInfoFactory;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.ASTORE;
import gov.nasa.jpf.jvm.bytecode.DUP;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.MONITORENTER;
import gov.nasa.jpf.jvm.bytecode.VariableAccessor;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public abstract class FieldInstruction
extends Instruction
implements VariableAccessor {
    static FieldLockInfoFactory fliFactory;
    static boolean skipFinals;
    protected String fname;
    protected String className;
    protected String varId;
    protected FieldInfo fi;
    protected int size;
    protected boolean isReferenceField;

    public static void init(Config config) throws Config.Exception {
        if (config.getBoolean("vm.por") && config.getBoolean("vm.por.sync_detection")) {
            fliFactory = config.getEssentialInstance("vm.por.fli_factory.class", FieldLockInfoFactory.class);
            skipFinals = config.getBoolean("vm.por.skip_finals", true);
        }
    }

    @Override
    public void setPeer(org.apache.bcel.generic.Instruction i, ConstantPool cp) {
        org.apache.bcel.generic.FieldInstruction fi = (org.apache.bcel.generic.FieldInstruction)i;
        ConstantPoolGen cpg = ClassInfo.getConstantPoolGen(cp);
        this.fname = fi.getFieldName(cpg);
        this.className = fi.getReferenceType(cpg).toString();
        Type ft = fi.getFieldType(cpg);
        if (ft instanceof ReferenceType) {
            this.isReferenceField = true;
        }
        this.size = ft.getSize();
    }

    public abstract FieldInfo getFieldInfo();

    public abstract ElementInfo getLastElementInfo();

    public abstract ElementInfo peekElementInfo(ThreadInfo var1);

    public boolean isReferenceField() {
        return this.isReferenceField;
    }

    public int getFieldSize() {
        return this.size;
    }

    public String getId(ElementInfo ei) {
        if (ei != null) {
            return ei.toString() + '.' + this.fname;
        }
        return "?." + this.fname;
    }

    @Override
    public String getVariableId() {
        if (this.varId == null) {
            this.varId = this.className + '.' + this.fname;
        }
        return this.varId;
    }

    protected boolean isLockProtected(ThreadInfo ti, ElementInfo ei) {
        FieldLockInfo flInfoNext;
        FieldInfo fi = this.getFieldInfo();
        FieldLockInfo flInfo = ei.getFieldLockInfo(fi);
        if (flInfo == null) {
            flInfoNext = fliFactory.createFieldLockInfo(ti, ei, fi);
            ei.setFieldLockInfo(fi, flInfoNext);
        } else {
            flInfoNext = flInfo.checkProtection(ti, ei, fi);
            if (flInfo != flInfoNext) {
                ei.setFieldLockInfo(fi, flInfoNext);
            }
        }
        return flInfoNext.isProtected();
    }

    protected boolean isMonitorEnterPrologue() {
        int off = this.offset + 1;
        Instruction[] code = this.mi.getInstructions();
        if (off < code.length - 3 && code[off] instanceof DUP) {
            if (code[++off] instanceof ASTORE) {
                ++off;
            }
            if (code[off] instanceof MONITORENTER) {
                return true;
            }
        }
        return false;
    }

    protected boolean createAndSetFieldCG(SystemState ss, ElementInfo ei, ThreadInfo ti) {
        ChoiceGenerator<ThreadInfo> cg = ss.getSchedulerFactory().createSharedFieldAccessCG(ei, ti);
        if (cg != null) {
            ss.setNextChoiceGenerator(cg);
            ti.skipInstructionLogging();
            return true;
        }
        return false;
    }
}

