/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.jvm.ArrayIndexOutOfBoundsExecutiveException;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.DynamicElementInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.ArrayInstruction;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.StoreInstruction;

public abstract class ArrayStoreInstruction
extends ArrayInstruction
implements StoreInstruction {
    @Override
    public Instruction execute(SystemState ss, KernelState ks, ThreadInfo ti) {
        ClassInfo arrayElementCi;
        ClassInfo elementCi;
        int arrayRef = this.peekArrayRef(ti);
        if (arrayRef == -1) {
            return ti.createAndThrowException("java.lang.NullPointerException");
        }
        DynamicArea da = DynamicArea.getHeap();
        Object e = da.get(arrayRef);
        if (this.isNewPorBoundary((ElementInfo)e, ti) && this.createAndSetArrayCG(ss, (ElementInfo)e, ti)) {
            return this;
        }
        int esize = this.getElementSize();
        Object attr = esize == 1 ? ti.getOperandAttr() : ti.getLongOperandAttr();
        long value = this.getValue(ti);
        int index = ti.pop();
        ti.pop();
        ClassInfo c = ((ElementInfo)e).getClassInfo();
        if (c.isReferenceArray() && value != -1L && !(elementCi = ((DynamicElementInfo)da.get((int)value)).getClassInfo()).isInstanceOf(arrayElementCi = c.getComponentClassInfo())) {
            String exception = "java.lang.ArrayStoreException";
            String exceptionDescription = elementCi.getName();
            return ti.createAndThrowException(exception, exceptionDescription);
        }
        try {
            this.setField((ElementInfo)e, index, value);
            ((ElementInfo)e).setElementAttrNoClone(index, attr);
            return this.getNext(ti);
        }
        catch (ArrayIndexOutOfBoundsExecutiveException ex) {
            return ex.getInstruction();
        }
    }

    int peekArrayRef(ThreadInfo ti) {
        return ti.peek(2);
    }

    protected void setField(ElementInfo e, int index, long value) throws ArrayIndexOutOfBoundsExecutiveException {
        e.checkArrayBounds(index);
        e.setElement(index, (int)value);
    }

    protected long getValue(ThreadInfo th) {
        return th.pop();
    }
}

