/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.jvm.ArrayIndexOutOfBoundsExecutiveException;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.ArrayInstruction;
import gov.nasa.jpf.jvm.bytecode.Instruction;

public abstract class ArrayLoadInstruction
extends ArrayInstruction {
    @Override
    public Instruction execute(SystemState ss, KernelState ks, ThreadInfo ti) {
        int arrayRef = ti.peek(1);
        if (arrayRef == -1) {
            return ti.createAndThrowException("java.lang.NullPointerException");
        }
        Object e = ks.da.get(arrayRef);
        if (this.isNewPorBoundary((ElementInfo)e, ti) && this.createAndSetArrayCG(ss, (ElementInfo)e, ti)) {
            return this;
        }
        int index = ti.pop();
        ti.pop();
        try {
            this.push(ti, (ElementInfo)e, index);
            Object attr = ((ElementInfo)e).getElementAttr(index);
            if (this.getElementSize() == 1) {
                ti.setOperandAttrNoClone(attr);
            } else {
                ti.setLongOperandAttrNoClone(attr);
            }
            return this.getNext(ti);
        }
        catch (ArrayIndexOutOfBoundsExecutiveException ex) {
            return ex.getInstruction();
        }
    }

    protected boolean isReference() {
        return false;
    }

    protected void push(ThreadInfo th, ElementInfo e, int index) throws ArrayIndexOutOfBoundsExecutiveException {
        e.checkArrayBounds(index);
        th.push(e.getElement(index), this.isReference());
    }
}

