/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.LocalVariableInstruction;

public class ALOAD
extends LocalVariableInstruction {
    public void initialize(int index) {
        this.index = index;
    }

    @Override
    public Instruction execute(SystemState ss, KernelState ks, ThreadInfo th) {
        th.pushLocal(this.index);
        return this.getNext(th);
    }

    @Override
    public int getLength() {
        if (this.index > 3) {
            return 2;
        }
        return 1;
    }

    @Override
    public int getByteCode() {
        switch (this.index) {
            case 0: {
                return 42;
            }
            case 1: {
                return 43;
            }
            case 2: {
                return 44;
            }
            case 3: {
                return 45;
            }
        }
        return 25;
    }

    @Override
    public String getMnemonic() {
        String mnemonic = "aload";
        if (this.index >= 0) {
            return mnemonic + '_' + this.index;
        }
        return mnemonic;
    }
}

