/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.abstraction.symmetry;

import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DynamicElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.abstraction.abstractor.AbstractorProcess;
import gov.nasa.jpf.jvm.abstraction.abstractor.AmmendableAbstractorConfiguration;
import gov.nasa.jpf.jvm.abstraction.abstractor.ObjectAbstractor;
import gov.nasa.jpf.jvm.abstraction.state.BagObject;
import gov.nasa.jpf.jvm.abstraction.state.SetObject;
import gov.nasa.jpf.jvm.abstraction.symmetry.CanonicalEqBag;
import gov.nasa.jpf.jvm.abstraction.symmetry.CanonicalEqSet;
import gov.nasa.jpf.jvm.abstraction.symmetry.CollectionFactory;
import gov.nasa.jpf.jvm.abstraction.symmetry.EqBag;
import gov.nasa.jpf.jvm.abstraction.symmetry.EqSet;

public class SymmetricCollectionsAbstractorAmmendment
implements AmmendableAbstractorConfiguration.ObjectAbstractorAmmendment {
    protected static final String eqSetName = CanonicalEqSet.class.getName();
    protected static final String eqBagName = CanonicalEqBag.class.getName();
    protected final SetAbstractor setAbs = new SetAbstractor();
    protected final BagAbstractor bagAbs = new BagAbstractor();

    @Override
    public ObjectAbstractor<?> getObjectAbstractor(ClassInfo ci, ObjectAbstractor<?> sofar) {
        String cname = ci.getName();
        if (cname.equals(eqSetName)) {
            this.setAbs.dataField = ci.getInstanceField("data");
            return this.setAbs;
        }
        if (cname.equals(eqBagName)) {
            this.bagAbs.dataField = ci.getInstanceField("data");
            return this.bagAbs;
        }
        return sofar;
    }

    protected static class SetAbstractor
    implements ObjectAbstractor<SetObject> {
        public FieldInfo dataField = null;

        protected SetAbstractor() {
        }

        @Override
        public SetObject createInstanceSkeleton(DynamicElementInfo dei) {
            return new SetObject();
        }

        @Override
        public void fillInstanceData(DynamicElementInfo dei, SetObject skel, AbstractorProcess procInfo) {
            DynamicElementInfo aei = dei.getFieldDereference(this.dataField);
            skel.classId = dei.getClassInfo().getUniqueId();
            int[] oldRefs = aei.getFields().dumpRawValues();
            EqSet newRefs = CollectionFactory.newEqSet();
            for (int i = 0; i < oldRefs.length; ++i) {
                newRefs.add(procInfo.mapOldHeapRef(oldRefs[i]));
            }
            skel.refs = newRefs;
        }
    }

    protected static class BagAbstractor
    implements ObjectAbstractor<BagObject> {
        public FieldInfo dataField = null;

        protected BagAbstractor() {
        }

        @Override
        public BagObject createInstanceSkeleton(DynamicElementInfo dei) {
            return new BagObject();
        }

        @Override
        public void fillInstanceData(DynamicElementInfo dei, BagObject skel, AbstractorProcess procInfo) {
            DynamicElementInfo aei = dei.getFieldDereference(this.dataField);
            skel.classId = dei.getClassInfo().getUniqueId();
            int[] oldRefs = aei.getFields().dumpRawValues();
            EqBag newRefs = CollectionFactory.newEqBag();
            for (int i = 0; i < oldRefs.length; ++i) {
                newRefs.add(procInfo.mapOldHeapRef(oldRefs[i]));
            }
            skel.refs = newRefs;
        }
    }
}

