/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.abstraction.symmetry;

import gov.nasa.jpf.jvm.abstraction.symmetry.EqBag;
import gov.nasa.jpf.jvm.abstraction.symmetry.SymEqCollection;
import gov.nasa.jpf.util.Misc;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

class CanonicalEqBag<T>
implements EqBag<T> {
    Object[] data = Misc.emptyObjectArray;

    CanonicalEqBag() {
    }

    @Override
    public boolean add(T o) {
        int i;
        int len = this.data.length;
        int hash = System.identityHashCode(o);
        Object[] newData = new Object[len + 1];
        for (i = 0; i < len && hash > System.identityHashCode(this.data[i]); ++i) {
            newData[i] = this.data[i];
        }
        newData[i] = o;
        System.arraycopy(this.data, i, newData, i + 1, len - i);
        this.data = newData;
        return true;
    }

    @Override
    public boolean addAll(SymEqCollection<? extends T> c) {
        return this.addAll((Collection)((Object)c));
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean modified = false;
        for (T e : c) {
            modified |= this.add(e);
        }
        return modified;
    }

    @Override
    public void clear() {
        this.data = new Object[0];
    }

    @Override
    public boolean contains(Object o) {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] != o) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(SymEqCollection<?> c) {
        return this.containsAll((Collection)((Object)c));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.data.length == 0;
    }

    @Override
    public Iterator<T> iterator() {
        return Arrays.asList(this.data).iterator();
    }

    @Override
    public boolean remove(Object o) {
        int len = this.data.length;
        for (int i = 0; i < len; ++i) {
            if (this.data[i] != o) continue;
            Object[] newData = new Object[len - 1];
            if (i > 0) {
                System.arraycopy(this.data, 0, newData, 0, i);
            }
            if (len - i - 1 > 0) {
                System.arraycopy(this.data, i + 1, newData, i, len - i - 1);
            }
            this.data = newData;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(SymEqCollection<?> c) {
        return this.removeAll((Collection)((Object)c));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object th : c) {
            modified |= this.remove(th);
        }
        return modified;
    }

    @Override
    public boolean retainAll(SymEqCollection<?> c) {
        return this.retainAll((Collection)((Object)c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        for (T e : this) {
            if (c.contains(e)) continue;
            modified |= this.remove(e);
        }
        return modified;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.data.clone();
    }

    @Override
    public <V> V[] toArray(V[] a) {
        if (a.length >= this.data.length) {
            System.arraycopy(this.data, 0, a, 0, this.data.length);
            return a;
        }
        return this.toArray();
    }

    @Override
    public CanonicalEqBag<T> clone() {
        CanonicalEqBag<T> that = new CanonicalEqBag<T>();
        that.data = this.data;
        return that;
    }
}

