/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.abstraction.linearization;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.abstraction.linearization.DefaultNodeOrderingHeuristic;
import gov.nasa.jpf.jvm.abstraction.linearization.NodeOrderingHeuristic;
import gov.nasa.jpf.jvm.abstraction.linearization.StateGraphLinearizerSkeleton;
import gov.nasa.jpf.jvm.abstraction.state.StateNode;
import gov.nasa.jpf.util.ObjVector;
import gov.nasa.jpf.util.ReadOnlyObjList;
import java.util.LinkedList;
import java.util.Queue;

public class HeuristicStateGraphLinearizer
extends StateGraphLinearizerSkeleton {
    protected NodeOrderingHeuristic heuristic;
    protected ReadOnlyObjList<StateNode> orderedNodes;
    protected final Queue<StateNode> withUnorderedRefs = new LinkedList<StateNode>();
    private final ObjVector<StateNode> unordered = new ObjVector();

    @Override
    public void init(Config config) throws Config.Exception {
        this.heuristic = config.getInstance("abstraction.linearization.heuristic.class", NodeOrderingHeuristic.class);
        if (this.heuristic == null) {
            this.heuristic = new DefaultNodeOrderingHeuristic();
        }
        this.heuristic.init(config);
    }

    @Override
    protected void linearizeFrom(StateNode root) {
        this.orderedNodes = this.getOrderedNodes();
        this.withUnorderedRefs.clear();
        this.unordered.clear();
        assert (StateNode.linearIdOf(root) == -2);
        this.maybeAdd(root);
        int next = 0;
        while (true) {
            StateNode cur;
            if (next < this.orderedNodes.length()) {
                cur = this.orderedNodes.get(next);
                if (cur.refsOrdered()) {
                    for (StateNode child : cur.getRefs()) {
                        this.maybeAdd(child);
                    }
                } else {
                    this.withUnorderedRefs.add(cur);
                }
                ++next;
                continue;
            }
            if (this.withUnorderedRefs.isEmpty()) break;
            cur = this.withUnorderedRefs.remove();
            for (StateNode child : cur.getRefs()) {
                if (StateNode.linearIdOf(child) != -2) continue;
                this.unordered.add(child);
            }
            if (this.unordered.size() <= 0) continue;
            this.unordered.sort(StateNode.vmIdComparator);
            this.unordered.sort(this.heuristic);
            for (StateNode child : this.unordered) {
                this.maybeAdd(child);
            }
            this.unordered.clear();
        }
    }
}

