/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.abstraction.filter;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.AnnotationInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.abstraction.filter.AmmendableFilterConfiguration;
import gov.nasa.jpf.jvm.abstraction.filter.FramePolicy;

public class IgnoresFromAnnotations
implements AmmendableFilterConfiguration.FieldAmmendment,
AmmendableFilterConfiguration.FrameAmmendment {
    protected Config config;

    public IgnoresFromAnnotations(Config config) throws Config.Exception {
        this.config = config;
    }

    @Override
    public boolean ammendFieldInclusion(FieldInfo fi, boolean sofar) {
        AnnotationInfo ann = fi.getAnnotation("gov.nasa.jpf.jvm.abstraction.filter.FilterField");
        if (ann != null) {
            String condition = ann.getValueAsString("condition");
            boolean invert = ann.getValueAsBoolean("invert");
            if (condition == null || this.config.getBoolean(condition) == !invert) {
                return false;
            }
        }
        return sofar;
    }

    @Override
    public FramePolicy ammendFramePolicy(MethodInfo mi, FramePolicy sofar) {
        AnnotationInfo ann = mi.getAnnotation("gov.nasa.jpf.jvm.abstraction.filter.FilterFrame");
        if (ann != null) {
            if (ann.getValueAsBoolean("filterData")) {
                sofar.includeLocals = false;
                sofar.includeOps = false;
            }
            if (ann.getValueAsBoolean("filterPC")) {
                sofar.includePC = false;
            }
            if (ann.getValueAsBoolean("filterSubframes")) {
                sofar.recurse = false;
            }
        }
        return sofar;
    }
}

