/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.abstraction.filter;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.ArrayFields;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DynamicElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.Fields;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.StackFrame;
import gov.nasa.jpf.jvm.StaticElementInfo;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.abstraction.filter.FramePolicy;
import gov.nasa.jpf.jvm.abstraction.filter.SimpleFilteringSerializer;
import gov.nasa.jpf.util.BitArray;
import gov.nasa.jpf.util.FinalBitSet;
import gov.nasa.jpf.util.IntVector;
import gov.nasa.jpf.util.ObjVector;

public class FilteringSerializer
extends SimpleFilteringSerializer {
    final ObjVector<FinalBitSet> instanceRefCache = new ObjVector();
    final ObjVector<FinalBitSet> staticRefCache = new ObjVector();
    protected transient IntVector heapMap = new IntVector(200);
    protected transient IntVector invHeapMap = new IntVector(200);

    @Override
    public void attach(JVM jvm) throws Config.Exception {
        super.attach(jvm);
    }

    FinalBitSet getIFieldsAreRefs(ClassInfo ci) {
        int cid = ci.getUniqueId();
        FinalBitSet v = this.instanceRefCache.get(cid);
        if (v == null) {
            BitArray b = new BitArray(ci.getInstanceDataSize());
            for (FieldInfo fi : this.filter.getMatchedInstanceFields(ci)) {
                if (!fi.isReference()) continue;
                b.set(fi.getStorageOffset());
            }
            v = FinalBitSet.create(b);
            if (v == null) {
                throw new IllegalStateException("Null BitArray returned.");
            }
            this.instanceRefCache.set(cid, v);
        }
        return v;
    }

    FinalBitSet getSFieldsAreRefs(ClassInfo ci) {
        int cid = ci.getUniqueId();
        FinalBitSet v = this.staticRefCache.get(cid);
        if (v == null) {
            BitArray b = new BitArray(ci.getStaticDataSize());
            for (FieldInfo fi : this.filter.getMatchedStaticFields(ci)) {
                if (!fi.isReference()) continue;
                b.set(fi.getStorageOffset());
            }
            v = FinalBitSet.create(b);
            if (v == null) {
                throw new IllegalStateException("Null BitArray returned.");
            }
            this.staticRefCache.set(cid, v);
        }
        return v;
    }

    protected void addObjRef(int objref) {
        if (objref < 0) {
            this.buf.add(-1);
        } else {
            int idx = this.heapMap.get(objref);
            if (idx == 0) {
                DynamicElementInfo d = (DynamicElementInfo)this.ks.da.get(objref);
                if (d == null) {
                    idx = -1;
                } else {
                    idx = this.invHeapMap.size();
                    this.invHeapMap.add(objref);
                }
                this.heapMap.set(objref, idx);
            }
            this.buf.add(idx);
        }
    }

    @Override
    protected int[] computeStoringData() {
        int v;
        int max;
        FinalBitSet filtered;
        ClassInfo ci;
        this.buf.clear();
        this.heapMap.clear();
        this.invHeapMap.clear();
        this.buf.add(this.ks.tl.length());
        for (ThreadInfo t : this.ks.tl.getThreads()) {
            this.addObjRef(t.getThreadObjectRef());
            this.buf.add(t.getStatus());
            StackFrame[] frames = t.dumpStack();
            int frameCountPos = this.buf.size();
            this.buf.add(0);
            int frameCount = 0;
            for (StackFrame f : frames) {
                int v2;
                int i;
                ++frameCount;
                MethodInfo mi = f.getMethodInfo();
                FramePolicy policy = this.getFramePolicy(mi);
                int pc = policy.includePC ? f.getPC().getOffset() : -1;
                this.buf.add2(mi.getGlobalId(), pc);
                int lenIdx = this.buf.size();
                this.buf.add(0);
                int len = 0;
                if (policy.includeLocals) {
                    int lcount = f.getLocalVariableCount();
                    len += lcount;
                    for (i = 0; i < lcount; ++i) {
                        v2 = f.getLocalVariable(i);
                        if (f.isLocalVariableRef(i)) {
                            this.addObjRef(v2);
                            continue;
                        }
                        this.buf.add(v2);
                    }
                }
                if (policy.includeOps) {
                    int ocount = f.getTopPos() + 1;
                    len += ocount;
                    for (i = 0; i < ocount; ++i) {
                        v2 = f.getAbsOperand(i);
                        if (f.isAbsOperandRef(i)) {
                            this.addObjRef(v2);
                            continue;
                        }
                        this.buf.add(v2);
                    }
                }
                this.buf.set(lenIdx, len);
                if (!policy.recurse) break;
            }
            this.buf.set(frameCountPos, frameCount);
        }
        this.buf.add(this.ks.sa.getLength());
        for (StaticElementInfo s : this.ks.sa) {
            if (s == null) {
                this.buf.add(-1);
                continue;
            }
            this.buf.add(s.getStatus());
            Fields fields = s.getFields();
            ci = fields.getClassInfo();
            filtered = this.getSFields(ci);
            FinalBitSet refs = this.getSFieldsAreRefs(ci);
            max = ci.getStaticDataSize();
            for (int i = 0; i < max; ++i) {
                if (filtered.get(i)) continue;
                v = fields.getIntValue(i);
                if (refs.get(i)) {
                    this.addObjRef(v);
                    continue;
                }
                this.buf.add(v);
            }
        }
        for (int newRef = 0; newRef < this.invHeapMap.size(); ++newRef) {
            DynamicElementInfo d = (DynamicElementInfo)this.ks.da.get(this.invHeapMap.get(newRef));
            Fields fields = d.getFields();
            ci = fields.getClassInfo();
            this.buf.add(ci.getUniqueId());
            if (fields instanceof ArrayFields) {
                int[] values = fields.dumpRawValues();
                this.buf.add(values.length);
                if (ci.isReferenceArray()) {
                    for (int i = 0; i < values.length; ++i) {
                        this.addObjRef(values[i]);
                    }
                    continue;
                }
                this.buf.append(values);
                continue;
            }
            filtered = this.getIFields(ci);
            FinalBitSet refs = this.getIFieldsAreRefs(ci);
            max = ci.getInstanceDataSize();
            for (int i = 0; i < max; ++i) {
                if (filtered.get(i)) continue;
                v = fields.getIntValue(i);
                if (refs.get(i)) {
                    this.addObjRef(v);
                    continue;
                }
                this.buf.add(v);
            }
        }
        return this.buf.toArray();
    }
}

