/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.abstraction.filter;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.abstraction.filter.FilterConfiguration;
import gov.nasa.jpf.jvm.abstraction.filter.FramePolicy;
import gov.nasa.jpf.util.ObjArray;
import gov.nasa.jpf.util.ObjVector;

public class AmmendableFilterConfiguration
implements FilterConfiguration {
    protected final ObjVector<FrameAmmendment> frameAmmendments = new ObjVector(0);
    protected final ObjVector<InstanceAmmendment> instanceAmmendments = new ObjVector(0);
    protected final ObjVector<StaticAmmendment> staticAmmendments = new ObjVector(0);
    protected final ObjVector<InstanceOverride> instanceOverrides = new ObjVector(0);

    @Override
    public void init(Config config) throws Config.Exception {
        this.appendConfiguredFrameAmmendments(config);
        this.appendConfiguredInstanceAmmendments(config);
        this.appendConfiguredStaticAmmendments(config);
        this.appendConfiguredInstanceOverrides(config);
    }

    protected void appendConfiguredFrameAmmendments(Config config) throws Config.Exception {
        ObjArray<FrameAmmendment> fas = config.getInstances("filter.frame_ammendments", FrameAmmendment.class);
        if (fas != null) {
            this.frameAmmendments.append(fas);
        }
    }

    protected void appendConfiguredInstanceAmmendments(Config config) throws Config.Exception {
        ObjArray<InstanceAmmendment> ias = config.getInstances("filter.instance_ammendments", InstanceAmmendment.class);
        if (ias != null) {
            this.instanceAmmendments.append(ias);
        }
    }

    protected void appendConfiguredStaticAmmendments(Config config) throws Config.Exception {
        ObjArray<StaticAmmendment> sas = config.getInstances("filter.static_ammendments", StaticAmmendment.class);
        if (sas != null) {
            this.staticAmmendments.append(sas);
        }
    }

    protected void appendConfiguredInstanceOverrides(Config config) throws Config.Exception {
        ObjArray<InstanceOverride> ios = config.getInstances("filter.instance_overrides", InstanceOverride.class);
        if (ios != null) {
            this.instanceOverrides.append(ios);
        }
    }

    public void appendFrameAmmendment(FrameAmmendment fa) {
        this.frameAmmendments.add(fa);
    }

    public void appendInstanceAmmendment(InstanceAmmendment ia) {
        this.instanceAmmendments.add(ia);
    }

    public void appendStaticAmmendment(StaticAmmendment sa) {
        this.staticAmmendments.add(sa);
    }

    public void appendFieldAmmendment(FieldAmmendment fa) {
        this.staticAmmendments.add(fa);
        this.instanceAmmendments.add(fa);
    }

    public void appendInstanceOverride(InstanceOverride io) {
        this.instanceOverrides.add(io);
    }

    @Override
    public FramePolicy getFramePolicy(MethodInfo mi) {
        FramePolicy policy = new FramePolicy();
        for (FrameAmmendment fa : this.frameAmmendments) {
            policy = fa.ammendFramePolicy(mi, policy);
        }
        return policy;
    }

    @Override
    public Iterable<FieldInfo> getMatchedInstanceFields(ClassInfo ci) {
        int fieldCount = ci.getNumberOfInstanceFields();
        ObjVector<FieldInfo> v = new ObjVector<FieldInfo>(fieldCount);
        for (int i = 0; i < fieldCount; ++i) {
            FieldInfo field = ci.getInstanceField(i);
            boolean include = true;
            for (InstanceAmmendment ia : this.instanceAmmendments) {
                include = ia.ammendFieldInclusion(field, include);
            }
            if (!include) continue;
            v.add(field);
        }
        Iterable<FieldInfo> ret = v;
        for (InstanceOverride io : this.instanceOverrides) {
            if (!io.isOverriding(ci)) continue;
            ret = io.getMatchedInstanceFields(ci, ret);
        }
        return ret;
    }

    @Override
    public Iterable<FieldInfo> getMatchedStaticFields(ClassInfo ci) {
        int fieldCount = ci.getNumberOfStaticFields();
        ObjVector<FieldInfo> v = new ObjVector<FieldInfo>(fieldCount);
        for (int i = 0; i < fieldCount; ++i) {
            FieldInfo field = ci.getStaticField(i);
            boolean include = true;
            for (StaticAmmendment sa : this.staticAmmendments) {
                include = sa.ammendFieldInclusion(field, include);
            }
            if (!include) continue;
            v.add(field);
        }
        return v;
    }

    public static interface InstanceOverride {
        public boolean isOverriding(ClassInfo var1);

        public Iterable<FieldInfo> getMatchedInstanceFields(ClassInfo var1, Iterable<FieldInfo> var2);
    }

    public static interface FieldAmmendment
    extends InstanceAmmendment,
    StaticAmmendment {
    }

    public static interface StaticAmmendment
    extends Ammendment {
        public boolean ammendFieldInclusion(FieldInfo var1, boolean var2);
    }

    public static interface InstanceAmmendment
    extends Ammendment {
        public boolean ammendFieldInclusion(FieldInfo var1, boolean var2);
    }

    public static interface FrameAmmendment
    extends Ammendment {
        public FramePolicy ammendFramePolicy(MethodInfo var1, FramePolicy var2);
    }

    public static interface Ammendment {
        public static final boolean POLICY_IGNORE = false;
        public static final boolean POLICY_INCLUDE = true;
    }
}

