/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.abstraction.abstractor;

import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.StackFrame;
import gov.nasa.jpf.jvm.abstraction.abstractor.AbstractorProcess;
import gov.nasa.jpf.jvm.abstraction.abstractor.FrameLocalAbstractor;
import gov.nasa.jpf.jvm.abstraction.filter.FramePolicy;
import gov.nasa.jpf.jvm.abstraction.state.FrameNode;
import gov.nasa.jpf.jvm.abstraction.state.ObjectNode;
import gov.nasa.jpf.util.IntVector;
import gov.nasa.jpf.util.ObjVector;

public final class FrameLocalAbstractors {
    public static final FrameLocalAbstractor defaultInstance = new PolicyBased(new FramePolicy());

    private FrameLocalAbstractors() {
    }

    public static FrameLocalAbstractor fromPolicy(FramePolicy policy) {
        if (policy.isDefaultPolicy()) {
            return defaultInstance;
        }
        return new PolicyBased(policy);
    }

    public static class PolicyBased
    implements FrameLocalAbstractor {
        protected FramePolicy policy;

        public PolicyBased(FramePolicy policy) {
            this.policy = policy;
        }

        @Override
        public FrameNode getFrameNode(StackFrame frame, AbstractorProcess procInfo) {
            int v;
            int i;
            FrameNode node = new FrameNode();
            MethodInfo mi = frame.getMethodInfo();
            node.methodId = mi.getGlobalId();
            node.instrOff = this.policy.includePC ? frame.getPC().getOffset() : -1;
            IntVector prims = new IntVector();
            ObjVector<ObjectNode> refs = new ObjVector<ObjectNode>();
            if (this.policy.includeLocals) {
                int localsLen = frame.getLocalVariableCount();
                for (i = 0; i < localsLen; ++i) {
                    v = frame.getLocalVariable(i);
                    if (frame.isLocalVariableRef(i)) {
                        refs.add(procInfo.mapOldHeapRef(v));
                        continue;
                    }
                    prims.add(v);
                }
            }
            if (this.policy.includeOps) {
                int operandsLen = frame.getTopPos() + 1;
                for (i = 0; i < operandsLen; ++i) {
                    v = frame.getAbsOperand(i);
                    if (frame.isAbsOperandRef(i)) {
                        refs.add(procInfo.mapOldHeapRef(v));
                        continue;
                    }
                    prims.add(v);
                }
            }
            node.prims = prims;
            node.refs = refs;
            return node;
        }
    }
}

