/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.abstraction.abstractor;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.abstraction.abstractor.AbstractorConfiguration;
import gov.nasa.jpf.jvm.abstraction.abstractor.ArrayAbstractors;
import gov.nasa.jpf.jvm.abstraction.abstractor.ClassObjectAbstractor;
import gov.nasa.jpf.jvm.abstraction.abstractor.FieldsMeta;
import gov.nasa.jpf.jvm.abstraction.abstractor.FieldsMetaBuilder;
import gov.nasa.jpf.jvm.abstraction.abstractor.FrameLocalAbstractor;
import gov.nasa.jpf.jvm.abstraction.abstractor.FrameLocalAbstractors;
import gov.nasa.jpf.jvm.abstraction.abstractor.ObjectAbstractor;
import gov.nasa.jpf.jvm.abstraction.abstractor.StackTailAbstractor;
import gov.nasa.jpf.jvm.abstraction.abstractor.StackTailAbstractors;
import gov.nasa.jpf.jvm.abstraction.abstractor.StaticsAbstractor;
import gov.nasa.jpf.jvm.abstraction.filter.DefaultFilterConfiguration;
import gov.nasa.jpf.jvm.abstraction.filter.FilterConfiguration;
import gov.nasa.jpf.jvm.abstraction.filter.FramePolicy;
import gov.nasa.jpf.jvm.abstraction.state.ClassObject;
import gov.nasa.jpf.jvm.abstraction.state.InstanceObject;
import gov.nasa.jpf.jvm.abstraction.state.PrimArrayObject;
import gov.nasa.jpf.jvm.abstraction.state.RefArrayObject;
import gov.nasa.jpf.jvm.abstraction.state.ThreadObject;

public class FilterBasedAbstractorConfiguration
implements AbstractorConfiguration {
    protected FilterConfiguration filter;
    protected final FieldsMetaBuilder metaBuilder = new FieldsMetaBuilder();

    @Override
    public void attach(JVM jvm) throws Config.Exception {
        this.filter = jvm.getConfig().getInstance("filter.class", FilterConfiguration.class);
        if (this.filter == null) {
            this.filter = new DefaultFilterConfiguration();
        }
        this.filter.init(jvm.getConfig());
    }

    @Override
    public ObjectAbstractor<?> getObjectAbstractor(ClassInfo ci) {
        if (ci.isArray()) {
            if (ci.isReferenceArray()) {
                return this.getRefArrayAbstractor(ci);
            }
            return this.getPrimArrayAbstractor(ci);
        }
        if (ci.isInstanceOf("java.lang.Class")) {
            return this.getClassObjAbstractor(ci);
        }
        Iterable<FieldInfo> relevant = this.filter.getMatchedInstanceFields(ci);
        if (ci.isInstanceOf("java.lang.Thread")) {
            return this.getThreadAbstractor(ci, relevant);
        }
        return this.getInstanceAbstractor(ci, relevant);
    }

    @Override
    public StaticsAbstractor getStaticsAbstractor(ClassInfo ci) {
        return this.getStaticsAbstractor(ci, this.filter.getMatchedStaticFields(ci));
    }

    @Override
    public StackTailAbstractor getStackTailAbstractor(MethodInfo mi) {
        return this.getStackTailAbstractor(mi, this.filter.getFramePolicy(mi));
    }

    @Override
    public FrameLocalAbstractor getFrameLocalAbstractor(MethodInfo mi) {
        return this.getFrameLocalAbstractor(mi, this.filter.getFramePolicy(mi));
    }

    protected ObjectAbstractor<ClassObject> getClassObjAbstractor(ClassInfo ci) {
        return new ClassObjectAbstractor();
    }

    protected ObjectAbstractor<ThreadObject> getThreadAbstractor(ClassInfo ci, Iterable<FieldInfo> relevant) {
        this.metaBuilder.addAll(relevant);
        FieldsMeta meta = new FieldsMeta(this.metaBuilder);
        ObjectAbstractor<ThreadObject> ret = meta.getThreadAbstractor();
        this.metaBuilder.reset();
        return ret;
    }

    protected ObjectAbstractor<InstanceObject> getInstanceAbstractor(ClassInfo ci, Iterable<FieldInfo> relevant) {
        this.metaBuilder.addAll(relevant);
        FieldsMeta meta = new FieldsMeta(this.metaBuilder);
        ObjectAbstractor<InstanceObject> ret = meta.getInstanceAbstractor();
        this.metaBuilder.reset();
        return ret;
    }

    protected ObjectAbstractor<PrimArrayObject> getPrimArrayAbstractor(ClassInfo ci) {
        return ArrayAbstractors.defaultPrimsInstance;
    }

    protected ObjectAbstractor<RefArrayObject> getRefArrayAbstractor(ClassInfo ci) {
        return ArrayAbstractors.defaultRefsInstance;
    }

    protected StaticsAbstractor getStaticsAbstractor(ClassInfo ci, Iterable<FieldInfo> relevant) {
        this.metaBuilder.addAll(relevant);
        StaticsAbstractor ret = new FieldsMeta(this.metaBuilder).getStaticsAbstractor();
        this.metaBuilder.reset();
        return ret;
    }

    protected StackTailAbstractor getStackTailAbstractor(MethodInfo mi, FramePolicy policy) {
        return StackTailAbstractors.fromPolicy(policy);
    }

    protected FrameLocalAbstractor getFrameLocalAbstractor(MethodInfo mi, FramePolicy policy) {
        return FrameLocalAbstractors.fromPolicy(policy);
    }
}

