/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.abstraction.abstractor;

import gov.nasa.jpf.jvm.FieldInfo;
import java.util.ArrayList;

public class FieldsMetaBuilder {
    protected final ArrayList<FieldInfo> relevantObj = new ArrayList();
    protected final ArrayList<FieldInfo> relevantPrim = new ArrayList();
    protected int nFields = 0;

    public FieldsMetaBuilder() {
    }

    public FieldsMetaBuilder(Iterable<FieldInfo> infos) {
        this.addAll(infos);
    }

    public void reset() {
        this.relevantObj.clear();
        this.relevantPrim.clear();
        this.nFields = 0;
    }

    public void addAll(Iterable<FieldInfo> infos) {
        for (FieldInfo fi : infos) {
            this.add(fi);
        }
    }

    public void add(FieldInfo fi) {
        ++this.nFields;
        if (fi.isReference()) {
            this.relevantObj.add(fi);
        } else {
            this.relevantPrim.add(fi);
            for (int j = 1; j < fi.getStorageSize(); ++j) {
                this.relevantPrim.add(null);
            }
        }
    }

    public FieldInfo[] getObjs() {
        return this.relevantObj.toArray(new FieldInfo[this.relevantObj.size()]);
    }

    public FieldInfo[] getPrims() {
        return this.relevantPrim.toArray(new FieldInfo[this.relevantPrim.size()]);
    }

    public int getNumberOfFields() {
        return this.nFields;
    }
}

