/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.abstraction.abstractor;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.abstraction.abstractor.FilterBasedAbstractorConfiguration;
import gov.nasa.jpf.jvm.abstraction.abstractor.ObjectAbstractor;
import gov.nasa.jpf.jvm.abstraction.abstractor.StaticsAbstractor;
import gov.nasa.jpf.util.Misc;
import gov.nasa.jpf.util.ObjArray;
import java.util.LinkedList;

public class AmmendableAbstractorConfiguration
extends FilterBasedAbstractorConfiguration {
    protected final LinkedList<ObjectAbstractorAmmendment> objAmmendments = new LinkedList();
    protected final LinkedList<StaticsAbstractorAmmendment> stAmmendments = new LinkedList();

    public void appendObjectAmmendment(ObjectAbstractorAmmendment oaa) {
        this.objAmmendments.addLast(oaa);
    }

    public void appendStaticsAmmendment(StaticsAbstractorAmmendment saa) {
        this.stAmmendments.addLast(saa);
    }

    public void prependObjectAmmendment(ObjectAbstractorAmmendment oaa) {
        this.objAmmendments.addFirst(oaa);
    }

    public void prependStaticsAmmendment(StaticsAbstractorAmmendment saa) {
        this.stAmmendments.addFirst(saa);
    }

    @Override
    public void attach(JVM jvm) throws Config.Exception {
        super.attach(jvm);
        this.appendConfiguredObjectAmmendments(jvm.getConfig());
        this.appendConfiguredStaticsAmmendments(jvm.getConfig());
    }

    protected void appendConfiguredObjectAmmendments(Config config) throws Config.Exception {
        ObjArray<ObjectAbstractorAmmendment> oaas = config.getInstances("abstraction.builder.object_ammendments", ObjectAbstractorAmmendment.class);
        if (oaas != null) {
            Misc.addAll(this.objAmmendments, oaas);
        }
    }

    protected void appendConfiguredStaticsAmmendments(Config config) throws Config.Exception {
        ObjArray<StaticsAbstractorAmmendment> saas = config.getInstances("abstraction.builder.statics_ammendments", StaticsAbstractorAmmendment.class);
        if (saas != null) {
            Misc.addAll(this.stAmmendments, saas);
        }
    }

    @Override
    public ObjectAbstractor<?> getObjectAbstractor(ClassInfo ci) {
        ObjectAbstractor<?> sofar = super.getObjectAbstractor(ci);
        for (ObjectAbstractorAmmendment oaa : this.objAmmendments) {
            sofar = oaa.getObjectAbstractor(ci, sofar);
            if (sofar != null) continue;
            throw new IllegalStateException("Invalid null return from " + oaa);
        }
        return sofar;
    }

    @Override
    public StaticsAbstractor getStaticsAbstractor(ClassInfo ci) {
        StaticsAbstractor sofar = super.getStaticsAbstractor(ci);
        for (StaticsAbstractorAmmendment saa : this.stAmmendments) {
            sofar = saa.getStaticsAbstractor(ci, sofar);
            if (sofar != null) continue;
            throw new IllegalStateException("Invalid null return from " + saa);
        }
        return sofar;
    }

    public static interface StaticsAbstractorAmmendment {
        public StaticsAbstractor getStaticsAbstractor(ClassInfo var1, StaticsAbstractor var2);
    }

    public static interface ObjectAbstractorAmmendment {
        public ObjectAbstractor<?> getObjectAbstractor(ClassInfo var1, ObjectAbstractor<?> var2);
    }
}

