/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.abstraction.abstractor;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.DynamicElementInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.StackFrame;
import gov.nasa.jpf.jvm.StaticElementInfo;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.abstraction.StateGraph;
import gov.nasa.jpf.jvm.abstraction.StateGraphBuilder;
import gov.nasa.jpf.jvm.abstraction.abstractor.AbstractorConfiguration;
import gov.nasa.jpf.jvm.abstraction.abstractor.AbstractorProcess;
import gov.nasa.jpf.jvm.abstraction.abstractor.CachedAbstractorConfiguration;
import gov.nasa.jpf.jvm.abstraction.abstractor.DefaultAbstractorConfiguration;
import gov.nasa.jpf.jvm.abstraction.abstractor.ObjectAbstractor;
import gov.nasa.jpf.jvm.abstraction.state.ClassesNode;
import gov.nasa.jpf.jvm.abstraction.state.ObjectNode;
import gov.nasa.jpf.jvm.abstraction.state.RootNode;
import gov.nasa.jpf.jvm.abstraction.state.StaticsNode;
import gov.nasa.jpf.jvm.abstraction.state.ThreadNode;
import gov.nasa.jpf.jvm.abstraction.state.ThreadObject;
import gov.nasa.jpf.jvm.abstraction.state.ThreadsNode;
import gov.nasa.jpf.jvm.abstraction.symmetry.CollectionFactory;
import gov.nasa.jpf.jvm.abstraction.symmetry.EqSet;
import gov.nasa.jpf.util.ObjVector;
import java.util.LinkedList;
import java.util.Queue;
import java.util.TreeMap;

public class AbstractorBasedBuilder
implements StateGraphBuilder {
    protected Process proc;
    protected KernelState ks;

    @Override
    public void attach(JVM jvm) throws Config.Exception {
        AbstractorConfiguration absConfig = jvm.getConfig().getInstance("abstraction.abstractor.config.class", AbstractorConfiguration.class);
        if (absConfig == null) {
            absConfig = new DefaultAbstractorConfiguration();
        }
        absConfig.attach(jvm);
        this.proc = new Process(absConfig);
        this.proc.attach(jvm);
        this.ks = jvm.getKernelState();
    }

    @Override
    public StateGraph buildStateGraph() {
        StateGraph g = new StateGraph(this.buildFromRoot());
        this.proc.fillData();
        this.proc.reset();
        return g;
    }

    protected RootNode buildFromRoot() {
        RootNode root = new RootNode();
        root.classes = this.buildClasses();
        root.threads = this.buildThreads();
        root.vmNodeId = 1;
        return root;
    }

    protected ClassesNode buildClasses() {
        TreeMap<Integer, StaticsNode> tree = new TreeMap<Integer, StaticsNode>();
        for (StaticElementInfo sei : this.ks.sa) {
            StaticsNode n;
            if (sei == null || (n = this.proc.getStaticsAbstractor(sei.getClassInfo()).getStaticsNode(sei, this.proc)) == null) continue;
            int idx = sei.getIndex();
            n.vmNodeId = 1000000 + idx;
            tree.put(new Integer(idx), n);
        }
        ClassesNode classes = new ClassesNode();
        classes.statics = tree;
        classes.vmNodeId = 2;
        return classes;
    }

    protected ThreadsNode buildThreads() {
        EqSet set = CollectionFactory.newEqSet();
        for (ThreadInfo ti : this.ks.tl.getThreads()) {
            set.add(this.buildThread(ti));
        }
        ThreadsNode threads = new ThreadsNode();
        threads.threads = set;
        threads.vmNodeId = 3;
        return threads;
    }

    protected ThreadNode buildThread(ThreadInfo ti) {
        StackFrame[] stack = ti.dumpStack();
        ThreadNode node = new ThreadNode();
        node.frames = new ObjVector(stack.length);
        node.status = ti.getStatus();
        node.threadObj = (ThreadObject)this.proc.mapOldHeapRefSpecial(ti.getThreadObjectRef());
        node.vmNodeId = 1000 + ti.getIndex();
        if (stack.length > 0) {
            this.proc.getStackTailAbstractor(stack[0].getMethodInfo()).addFrames(stack, 0, node, this.proc);
        }
        return node;
    }

    protected static class Process
    extends CachedAbstractorConfiguration
    implements AbstractorProcess {
        protected final ObjVector<ObjectNode> heapMap = new ObjVector();
        protected final Queue<FillInfo> needFilling = new LinkedList<FillInfo>();
        protected DynamicArea da;

        public Process(AbstractorConfiguration absConfig) {
            super(absConfig);
        }

        @Override
        public void attach(JVM jvm) throws Config.Exception {
            super.attach(jvm);
            this.da = jvm.getDynamicArea();
        }

        public void reset() {
            this.heapMap.clear();
        }

        @Override
        public ObjectNode mapOldHeapRef(int objref) {
            return this.doMap(objref, false);
        }

        public ObjectNode mapOldHeapRefSpecial(int objref) {
            return this.doMap(objref, true);
        }

        protected ObjectNode doMap(int objref, boolean nullOk) {
            if (objref < 0) {
                return null;
            }
            ObjectNode ret = this.heapMap.get(objref);
            if (ret == null) {
                DynamicElementInfo dei = (DynamicElementInfo)this.da.get(objref);
                if (dei == null) {
                    if (nullOk) {
                        return null;
                    }
                    throw new IllegalStateException("Illegal vm reference");
                }
                ObjectAbstractor<?> abs = this.getObjectAbstractor(dei.getClassInfo());
                ret = abs.createInstanceSkeleton(dei);
                if (ret != null) {
                    ret.vmNodeId = 1000000000 + objref;
                    this.heapMap.set(objref, ret);
                    this.needFilling.add(new FillInfo(ret, dei, abs));
                }
            }
            return ret;
        }

        public void fillData() {
            while (!this.needFilling.isEmpty()) {
                this.needFilling.remove().fill(this);
            }
        }

        protected static class FillInfo {
            public ObjectNode node;
            public DynamicElementInfo dei;
            public ObjectAbstractor<?> abs;

            public FillInfo(ObjectNode node, DynamicElementInfo dei, ObjectAbstractor<?> abs) {
                this.node = node;
                this.dei = dei;
                this.abs = abs;
            }

            public void fill(AbstractorProcess proc) {
                ObjectAbstractor<?> abs2 = this.abs;
                abs2.fillInstanceData(this.dei, this.node, proc);
            }
        }
    }
}

