/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.abstraction;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.abstraction.StateGraph;
import gov.nasa.jpf.jvm.abstraction.StateGraphLinearizer;
import gov.nasa.jpf.jvm.abstraction.StateGraphSerializer;
import gov.nasa.jpf.jvm.abstraction.linearization.HeuristicStateGraphLinearizer;
import gov.nasa.jpf.jvm.abstraction.state.StateNode;
import gov.nasa.jpf.util.IntVector;
import gov.nasa.jpf.util.ObjVector;
import gov.nasa.jpf.util.ReadOnlyObjList;

public class DefaultStateGraphSerializer
implements StateGraphSerializer {
    protected StateGraphLinearizer linearizer;
    protected final IntVector buf = new IntVector();
    protected final ObjVector<StateNode> nbuf = new ObjVector();

    @Override
    public void init(Config config) throws Config.Exception {
        this.linearizer = config.getInstance("abstraction.linearizer.class", StateGraphLinearizer.class);
        if (this.linearizer == null) {
            this.linearizer = new HeuristicStateGraphLinearizer();
        }
        this.linearizer.init(config);
    }

    @Override
    public int[] serializeStateGraph(StateGraph graph) throws JPFException {
        this.buf.clear();
        ReadOnlyObjList<StateNode> nodeList = this.linearizer.linearizeStateGraph(graph);
        for (StateNode n : nodeList) {
            this.serializeNodeTo(n, this.buf);
        }
        return this.buf.toArray();
    }

    protected void serializeNodeTo(StateNode n, IntVector v) {
        v.add(n.getNodeTypeId());
        n.addRefs(this.nbuf);
        if (!n.refsOrdered()) {
            this.nbuf.sort(StateNode.linearIdComparator);
        }
        v.add(this.nbuf.size());
        for (StateNode nn : this.nbuf) {
            v.add(StateNode.linearIdOf(nn));
        }
        this.nbuf.clear();
        int szIdx = v.size();
        v.add(0);
        n.addPrimData(v);
        v.set(szIdx, v.size() - szIdx - 1);
    }
}

