/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.JPF_gov_nasa_jpf_jvm_Verify;
import gov.nasa.jpf.jvm.ModelAPI;
import java.util.Random;

@ModelAPI
public class Verify {
    static final int MAX_COUNTERS = 10;
    static int[] counter;
    private static Random random;
    static Class<?> peer;

    private static Random getRandom() {
        if (random == null) {
            random = new Random(42L);
        }
        return random;
    }

    public static void setPeerClass(Class<?> cls) {
        peer = cls;
    }

    public static int getCounter(int id) {
        if (peer != null) {
            return JPF_gov_nasa_jpf_jvm_Verify.getCounter__I__I(null, 0, id);
        }
        if (counter == null) {
            counter = new int[id >= 10 ? id + 1 : 10];
        }
        if (id < 0 || id >= counter.length) {
            return 0;
        }
        return counter[id];
    }

    public static void resetCounter(int id) {
        if (peer != null) {
            JPF_gov_nasa_jpf_jvm_Verify.resetCounter__I__V(null, 0, id);
        } else if (counter != null && id >= 0 && id < counter.length) {
            Verify.counter[id] = 0;
        }
    }

    public static int incrementCounter(int id) {
        if (peer != null) {
            return JPF_gov_nasa_jpf_jvm_Verify.incrementCounter__I__I(null, 0, id);
        }
        if (counter == null) {
            counter = new int[id >= 10 ? id + 1 : 10];
        } else if (id >= counter.length) {
            int[] newCounter = new int[id + 1];
            System.arraycopy(counter, 0, newCounter, 0, counter.length);
            counter = newCounter;
        }
        if (id >= 0 && id < counter.length) {
            int n = id;
            int n2 = counter[n] + 1;
            counter[n] = n2;
            return n2;
        }
        return 0;
    }

    public static void addComment(String s) {
    }

    public static void assertTrue(String s, boolean cond) {
        if (!cond) {
            System.out.println(s);
            Verify.assertTrue(cond);
        }
    }

    public static void assertTrue(boolean cond) {
        if (!cond) {
            throw new AssertionError((Object)"Verify.assertTrue failed");
        }
    }

    public static void atLabel(String label) {
    }

    public static void atLabel(int label) {
    }

    public static void beginAtomic() {
    }

    public static void endAtomic() {
    }

    public static void boring(boolean cond) {
    }

    public static void busyWait(long duration) {
        while (duration > 0L) {
            --duration;
        }
    }

    public static boolean isCalledFromClass(String refClsName) {
        Throwable t = new Throwable();
        StackTraceElement[] st = t.getStackTrace();
        if (st.length < 3) {
            return false;
        }
        try {
            Class<?> refClazz = Class.forName(refClsName);
            Class<?> callClazz = Class.forName(st[2].getClassName());
            return refClazz.isAssignableFrom(callClazz);
        }
        catch (ClassNotFoundException cfnx) {
            return false;
        }
    }

    public static void ignoreIf(boolean cond) {
    }

    public static void instrumentPoint(String label) {
    }

    public static void instrumentPointDeep(String label) {
    }

    public static void instrumentPointDeepRecur(String label, int depth) {
    }

    public static void interesting(boolean cond) {
    }

    public static void print(String s) {
        System.out.println(s);
    }

    public static void print(String s, int i) {
        System.out.println(s + " : " + i);
    }

    public static void print(String s, boolean b) {
        System.out.println(s + " : " + b);
    }

    public static void println() {
        System.out.println();
    }

    public static void print(String ... args) {
        for (String s : args) {
            System.out.print(s);
        }
    }

    public static void setFieldAttribute(Object o, String fieldName, int val) {
    }

    public static int getFieldAttribute(Object o, String fieldName) {
        return 0;
    }

    public static void setLocalAttribute(String varName, int val) {
    }

    public static int getLocalAttribute(String varName) {
        return 0;
    }

    public static void setElementAttribute(Object arr, int idx, int val) {
    }

    public static int getElementAttribute(Object arr, int idx) {
        return 0;
    }

    public static boolean getBoolean() {
        return (System.currentTimeMillis() & 1L) != 0L;
    }

    public static boolean getBoolean(boolean falseFirst) {
        return Verify.getBoolean();
    }

    public static int getInt(int min, int max) {
        return Verify.getRandom().nextInt(max - min + 1) + min;
    }

    public static Object getObject(String key) {
        return "?";
    }

    public static int getInt(String key) {
        return Verify.getRandom().nextInt();
    }

    public static double getDouble(String key) {
        return Verify.getRandom().nextDouble();
    }

    public static int random(int max) {
        return Verify.getRandom().nextInt(max + 1);
    }

    public static boolean randomBool() {
        return Verify.getRandom().nextBoolean();
    }

    public static long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static Object randomObject(String type) {
        return null;
    }

    public static boolean vmIsMatchingStates() {
        return false;
    }

    public static void storeTrace(String fileName, String comment) {
    }

    public static void storeTraceIf(boolean cond, String fileName, String comment) {
        if (cond) {
            Verify.storeTrace(fileName, comment);
        }
    }

    public static void storeTraceAndTerminate(String fileName, String comment) {
        Verify.storeTrace(fileName, comment);
        Verify.terminateSearch();
    }

    public static void storeTraceAndTerminateIf(boolean cond, String fileName, String comment) {
        if (cond) {
            Verify.storeTrace(fileName, comment);
            Verify.terminateSearch();
        }
    }

    public static boolean isTraceReplay() {
        return false;
    }

    public static void terminateSearch() {
    }

    public static void setProperties(String ... p) {
    }
}

