/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.ClassInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class Types {
    public static final byte T_ARRAY = 13;
    public static final byte T_BOOLEAN = 4;
    public static final byte T_BYTE = 8;
    public static final byte T_CHAR = 5;
    public static final byte T_DOUBLE = 7;
    public static final byte T_FLOAT = 6;
    public static final byte T_INT = 10;
    public static final byte T_LONG = 11;
    public static final byte T_OBJECT = 14;
    public static final byte T_REFERENCE = 14;
    public static final byte T_SHORT = 9;
    public static final byte T_VOID = 12;

    public static byte[] getArgumentTypes(String signature) {
        int i = 1;
        int nArgs = 0;
        while (signature.charAt(i) != ')') {
            i += Types.getTypeLength(signature, i);
            ++nArgs;
        }
        byte[] args = new byte[nArgs];
        i = 1;
        for (int j = 0; j < nArgs; ++j) {
            int end = i + Types.getTypeLength(signature, i);
            String arg = signature.substring(i, end);
            i = end;
            args[j] = Types.getBaseType(arg);
        }
        return args;
    }

    public static String[] getArgumentTypeNames(String signature) {
        int len = signature.length();
        if (len > 1 && signature.charAt(1) == ')') {
            return new String[0];
        }
        ArrayList<String> a = new ArrayList<String>();
        int i = 1;
        while (signature.charAt(i) != ')') {
            int end = i + Types.getTypeLength(signature, i);
            String arg = signature.substring(i, end);
            i = end;
            a.add(Types.getTypeName(arg));
        }
        String[] typeNames = new String[a.size()];
        a.toArray(typeNames);
        return typeNames;
    }

    public static int getArgumentsSize(String sig) {
        int n = 0;
        int i = 1;
        while (sig.charAt(i) != ')') {
            switch (sig.charAt(i)) {
                case 'L': {
                    while (sig.charAt(++i) != ';') {
                    }
                    ++n;
                    break;
                }
                case '[': {
                    while (sig.charAt(++i) == '[') {
                    }
                    if (sig.charAt(i) == 'L') {
                        while (sig.charAt(++i) != ';') {
                        }
                    }
                    ++n;
                    break;
                }
                case 'D': 
                case 'J': {
                    n += 2;
                    break;
                }
                default: {
                    ++n;
                }
            }
            ++i;
        }
        return n;
    }

    public static String getArrayElementType(String type) {
        if (type.charAt(0) != '[') {
            throw new JPFException("not an array type");
        }
        return type.substring(1);
    }

    public static byte getBaseType(String type) {
        switch (type.charAt(0)) {
            case 'B': {
                return 8;
            }
            case 'C': {
                return 5;
            }
            case 'D': {
                return 7;
            }
            case 'F': {
                return 6;
            }
            case 'I': {
                return 10;
            }
            case 'J': {
                return 11;
            }
            case 'L': {
                return 14;
            }
            case 'S': {
                return 9;
            }
            case 'V': {
                return 12;
            }
            case 'Z': {
                return 4;
            }
            case '[': {
                return 13;
            }
        }
        throw new JPFException("invalid type string: " + type);
    }

    public static String getJNISignature(String mangledName) {
        int i = mangledName.indexOf("__");
        String sig = null;
        if (i > 0) {
            int k = 0;
            int r = mangledName.indexOf("__", i + 2);
            boolean gotReturnType = false;
            int len = mangledName.length();
            char[] buf = new char[len + 2];
            buf[k++] = 40;
            i += 2;
            while (i < len) {
                if (i == r) {
                    if (i + 2 >= len) break;
                    ++i;
                    buf[k++] = 41;
                    gotReturnType = true;
                } else {
                    char c = mangledName.charAt(i);
                    if (c == '_') {
                        if (++i < len) {
                            c = mangledName.charAt(i);
                            switch (c) {
                                case '1': {
                                    buf[k++] = 95;
                                    break;
                                }
                                case '2': {
                                    buf[k++] = 59;
                                    break;
                                }
                                case '3': {
                                    buf[k++] = 91;
                                    break;
                                }
                                default: {
                                    buf[k++] = 47;
                                    buf[k++] = c;
                                    break;
                                }
                            }
                        } else {
                            buf[k++] = 47;
                        }
                    } else {
                        buf[k++] = c;
                    }
                }
                ++i;
            }
            if (!gotReturnType) {
                buf[k++] = 41;
                buf[k++] = 86;
            }
            sig = new String(buf, 0, k);
        }
        return sig;
    }

    public static String getJNIMangledMethodName(Method m) {
        String name = m.getName();
        Class<?>[] pt = m.getParameterTypes();
        StringBuilder s = new StringBuilder(name.length() + pt.length * 16);
        s.append(name);
        s.append("__");
        for (int i = 0; i < pt.length; ++i) {
            s.append(Types.getJNITypeCode(pt[i].getName()));
        }
        Class<?> rt = m.getReturnType();
        s.append("__");
        s.append(Types.getJNITypeCode(rt.getName()));
        return s.toString();
    }

    public static String getJNIMangledMethodName(String cls, String name, String signature) {
        StringBuilder s = new StringBuilder(signature.length() + 10);
        int slen = signature.length();
        if (cls != null) {
            s.append(cls.replace('.', '_'));
        }
        s.append(name);
        s.append("__");
        block7: for (int i = 1; i < slen; ++i) {
            char c = signature.charAt(i);
            switch (c) {
                case '/': {
                    s.append('_');
                    continue block7;
                }
                case '_': {
                    s.append("_1");
                    continue block7;
                }
                case ';': {
                    s.append("_2");
                    continue block7;
                }
                case '[': {
                    s.append("_3");
                    continue block7;
                }
                case ')': {
                    s.append("__");
                    continue block7;
                }
                default: {
                    s.append(c);
                }
            }
        }
        return s.toString();
    }

    public static String getJNIMethodName(String mangledName) {
        int i = mangledName.indexOf("__");
        if (i > 0) {
            return mangledName.substring(0, i);
        }
        return mangledName;
    }

    public static String getJNITypeCode(String type) {
        StringBuilder sb = new StringBuilder(32);
        int l = type.length() - 1;
        while (type.charAt(l) == ']') {
            sb.append("_3");
            l -= 2;
        }
        if ((type = type.substring(0, l + 1)).equals("int")) {
            sb.append('I');
        } else if (type.equals("long")) {
            sb.append('J');
        } else if (type.equals("boolean")) {
            sb.append('Z');
        } else if (type.equals("char")) {
            sb.append('C');
        } else if (type.equals("byte")) {
            sb.append('B');
        } else if (type.equals("short")) {
            sb.append('S');
        } else if (type.equals("double")) {
            sb.append('D');
        } else if (type.equals("float")) {
            sb.append('F');
        } else if (type.equals("void")) {
            sb.append('V');
        } else {
            sb.append('L');
            block5: for (int i = 0; i < type.length(); ++i) {
                char c = type.charAt(i);
                switch (c) {
                    case '.': {
                        sb.append('_');
                        continue block5;
                    }
                    case '_': {
                        sb.append("_1");
                        continue block5;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            sb.append("_2");
        }
        return sb.toString();
    }

    public static int getNumberOfStackSlots(String signature, boolean isStatic) {
        int nArgSlots = 0;
        int n = isStatic ? 0 : 1;
        int sigLen = signature.length();
        block6: for (int i = 1; i < sigLen; ++i) {
            switch (signature.charAt(i)) {
                case ')': {
                    nArgSlots = n;
                    n = 0;
                    continue block6;
                }
                case 'L': {
                    while (signature.charAt(++i) != ';') {
                    }
                    ++n;
                    continue block6;
                }
                case '[': {
                    while (signature.charAt(++i) == '[') {
                    }
                    if (signature.charAt(i) == 'L') {
                        while (signature.charAt(++i) != ';') {
                        }
                    }
                    ++n;
                    continue block6;
                }
                case 'D': 
                case 'J': {
                    n += 2;
                    continue block6;
                }
                default: {
                    ++n;
                }
            }
        }
        if (n > nArgSlots) {
            return n;
        }
        return nArgSlots;
    }

    public static int getNumberOfArguments(String signature) {
        int sigLen = signature.length();
        int i = 1;
        int n = 0;
        while (i < sigLen) {
            switch (signature.charAt(i)) {
                case ')': {
                    return n;
                }
                case 'L': {
                    while (signature.charAt(++i) != ';') {
                    }
                    break;
                }
                case '[': {
                    while (signature.charAt(++i) == '[') {
                    }
                    if (signature.charAt(i) != 'L') break;
                    while (signature.charAt(++i) != ';') {
                    }
                    break;
                }
            }
            ++i;
            ++n;
        }
        assert (false) : "malformed signature: " + signature;
        return n;
    }

    public static boolean isReference(String type) {
        byte t = Types.getBaseType(type);
        return t == 13 || t == 14;
    }

    public static byte getReturnType(String signature) {
        int i = signature.indexOf(41);
        return Types.getBaseType(signature.substring(i + 1));
    }

    public static String getReturnTypeName(String signature) {
        int i = signature.indexOf(41);
        return Types.getTypeName(signature.substring(i + 1));
    }

    public static String getTypeCode(String type, boolean dotNotation) {
        String t = null;
        int arrayDim = 0;
        String string = type = dotNotation ? type.replace('/', '.') : type.replace('.', '/');
        if (type.charAt(0) == '[' || type.endsWith(";")) {
            t = type;
        } else {
            while (type.endsWith("[]")) {
                type = type.substring(0, type.length() - 2);
                ++arrayDim;
            }
            if (type.equals("byte")) {
                t = "B";
            } else if (type.equals("char")) {
                t = "C";
            } else if (type.equals("short")) {
                t = "S";
            } else if (type.equals("int")) {
                t = "I";
            } else if (type.equals("float")) {
                t = "F";
            } else if (type.equals("long")) {
                t = "J";
            } else if (type.equals("double")) {
                t = "D";
            } else if (type.equals("boolean")) {
                t = "Z";
            } else if (type.equals("void")) {
                t = "V";
            } else if (type.endsWith(";")) {
                t = type;
            }
            while (arrayDim-- > 0) {
                t = "[" + t;
            }
            if (t == null) {
                t = "L" + type + ';';
            }
        }
        return t;
    }

    public static String getCanonicalTypeName(String typeName) {
        typeName = typeName.replace('/', '.');
        int n = typeName.length() - 1;
        if (typeName.charAt(0) == '[') {
            if (typeName.charAt(1) == 'L' && typeName.charAt(n) != ';') {
                typeName = typeName + ';';
            }
            return typeName;
        }
        int i = typeName.indexOf(91);
        if (i > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            int j = i;
            while ((j = typeName.indexOf(91, j + 1)) > 0) {
                sb.append('[');
            }
            if (Types.isBasicType(typeName = typeName.substring(0, i))) {
                sb.append(Types.getTypeCode(typeName, true));
            } else {
                sb.append('L');
                sb.append(typeName);
                sb.append(';');
            }
            return sb.toString();
        }
        if (typeName.charAt(n) == ';') {
            return typeName.substring(1, n);
        }
        return typeName;
    }

    public static boolean isTypeCode(String t) {
        char c = t.charAt(0);
        if (c == '[') {
            return true;
        }
        if (t.length() == 1 && (c == 'B' || c == 'I' || c == 'S' || c == 'C' || c == 'F' || c == 'J' || c == 'D' || c == 'Z')) {
            return true;
        }
        return t.endsWith(";");
    }

    public static boolean isBasicType(String typeName) {
        return "boolean".equals(typeName) || "byte".equals(typeName) || "char".equals(typeName) || "int".equals(typeName) || "long".equals(typeName) || "double".equals(typeName) || "short".equals(typeName) || "float".equals(typeName);
    }

    public static String getTypeName(String type) {
        int len = type.length();
        char c = type.charAt(0);
        if (len == 1) {
            switch (c) {
                case 'B': {
                    return "byte";
                }
                case 'C': {
                    return "char";
                }
                case 'D': {
                    return "double";
                }
                case 'F': {
                    return "float";
                }
                case 'I': {
                    return "int";
                }
                case 'J': {
                    return "long";
                }
                case 'S': {
                    return "short";
                }
                case 'V': {
                    return "void";
                }
                case 'Z': {
                    return "boolean";
                }
            }
        }
        if (c == '[') {
            return Types.getTypeName(type.substring(1)) + "[]";
        }
        if (type.charAt(len - 1) == ';') {
            return type.substring(1, type.indexOf(59)).replace('/', '.');
        }
        throw new JPFException("invalid type string: " + type);
    }

    public static int getTypeSizeInBytes(String type) {
        switch (type.charAt(0)) {
            case 'V': {
                return 0;
            }
            case 'B': 
            case 'Z': {
                return 1;
            }
            case 'C': 
            case 'S': {
                return 2;
            }
            case 'F': 
            case 'I': 
            case 'L': 
            case '[': {
                return 4;
            }
            case 'D': 
            case 'J': {
                return 8;
            }
        }
        throw new JPFException("invalid type string: " + type);
    }

    public static int getTypeSize(String typeCode) {
        switch (typeCode.charAt(0)) {
            case 'V': {
                return 0;
            }
            case 'B': 
            case 'C': 
            case 'F': 
            case 'I': 
            case 'L': 
            case 'S': 
            case 'Z': 
            case '[': {
                return 1;
            }
            case 'D': 
            case 'J': {
                return 2;
            }
        }
        throw new JPFException("invalid type string: " + typeCode);
    }

    public static int getTypeSize(byte typeCode) {
        if (typeCode == 11 || typeCode == 7) {
            return 2;
        }
        return 1;
    }

    public static String asTypeName(String type) {
        if (type.startsWith("[") || type.endsWith(";")) {
            return Types.getTypeName(type);
        }
        return type;
    }

    public static int booleanToInt(boolean b) {
        return b ? 1 : 0;
    }

    public static long doubleToLong(double d) {
        return Double.doubleToLongBits(d);
    }

    public static int floatToInt(float f) {
        return Float.floatToIntBits(f);
    }

    public static int hiDouble(double d) {
        return Types.hiLong(Double.doubleToLongBits(d));
    }

    public static int hiLong(long l) {
        return (int)(l >> 32);
    }

    public static boolean instanceOf(String type, String ofType) {
        byte bType = Types.getBaseType(type);
        if (bType == 13 && ofType.equals("Ljava.lang.Object;")) {
            return true;
        }
        byte bOfType = Types.getBaseType(ofType);
        if (bType != bOfType) {
            return false;
        }
        switch (bType) {
            case 13: {
                return Types.instanceOf(type.substring(1), ofType.substring(1));
            }
            case 14: {
                return ClassInfo.getClassInfo(Types.getTypeName(type)).isInstanceOf(Types.getTypeName(ofType));
            }
        }
        return true;
    }

    public static boolean intToBoolean(int i) {
        return i != 0;
    }

    public static float intToFloat(int i) {
        return Float.intBitsToFloat(i);
    }

    public static double intsToDouble(int l, int h) {
        return Types.longToDouble(Types.intsToLong(l, h));
    }

    public static long intsToLong(int l, int h) {
        return (long)h << 32 | (long)l & 0xFFFFFFFFL;
    }

    public static int loDouble(double d) {
        return Types.loLong(Double.doubleToLongBits(d));
    }

    public static int loLong(long l) {
        return (int)(l & 0xFFFFFFFFL);
    }

    public static double longToDouble(long l) {
        return Double.longBitsToDouble(l);
    }

    private static int getTypeLength(String signature, int idx) {
        switch (signature.charAt(idx)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return 1;
            }
            case '[': {
                return 1 + Types.getTypeLength(signature, idx + 1);
            }
            case 'L': {
                int semicolon = signature.indexOf(59, idx);
                if (semicolon == -1) {
                    throw new JPFException("invalid type signature: " + signature);
                }
                return semicolon - idx + 1;
            }
        }
        throw new JPFException("invalid type signature");
    }
}

