/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DirectCallStackFrame;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.DynamicElementInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.ExceptionHandler;
import gov.nasa.jpf.jvm.ExceptionInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.MJIEnv;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.NoUncaughtExceptionsProperty;
import gov.nasa.jpf.jvm.StackFrame;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadData;
import gov.nasa.jpf.jvm.ThreadList;
import gov.nasa.jpf.jvm.Types;
import gov.nasa.jpf.jvm.UncaughtException;
import gov.nasa.jpf.jvm.Verify;
import gov.nasa.jpf.jvm.bytecode.INVOKESTATIC;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.InvokeInstruction;
import gov.nasa.jpf.jvm.bytecode.ReturnInstruction;
import gov.nasa.jpf.jvm.choice.BreakGenerator;
import gov.nasa.jpf.jvm.choice.ThreadChoiceFromSet;
import gov.nasa.jpf.util.HashData;
import gov.nasa.jpf.util.IntVector;
import gov.nasa.jpf.util.SparseObjVector;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ThreadInfo
implements Iterable<StackFrame>,
Comparable<ThreadInfo>,
Cloneable {
    static Logger log = JPF.getLogger("gov.nasa.jpf.jvm.ThreadInfo");
    public static final int NEW = 0;
    public static final int RUNNING = 1;
    public static final int BLOCKED = 2;
    public static final int UNBLOCKED = 3;
    public static final int WAITING = 4;
    public static final int TIMEOUT_WAITING = 5;
    public static final int NOTIFIED = 6;
    public static final int INTERRUPTED = 7;
    public static final int TIMEDOUT = 8;
    public static final int TERMINATED = 9;
    public static final String[] statusName = new String[]{"NEW", "RUNNING", "BLOCKED", "UNBLOCKED", "WAITING", "TIMEOUT_WAITING", "NOTIFIED", "INTERRUPTED", "TIMEDOUT", "TERMINATED"};
    static ThreadInfo currentThread;
    static ThreadInfo mainThread;
    protected ExceptionInfo pendingException;
    protected ThreadData threadData;
    protected ArrayList<StackFrame> stack = new ArrayList();
    protected StackFrame top = null;
    protected int topIdx = -1;
    public ThreadList list;
    public int index;
    public boolean tdChanged;
    protected final BitSet hasChanged = new BitSet();
    protected boolean isFirstStepInsn;
    boolean skipInstruction;
    boolean logInstruction;
    DirectCallStackFrame returnedDirectCall;
    Instruction nextPc;
    MJIEnv env;
    JVM vm;
    LinkedList<ElementInfo> lockedObjects;
    int lockRef = -1;
    static SparseObjVector<ThreadInfo> threadInfos;
    static String[] haltOnThrow;
    static boolean porInEffect;
    static boolean porFieldBoundaries;
    static boolean porSyncDetection;
    static int checkBudgetCount;

    static boolean init(Config config) {
        currentThread = null;
        mainThread = null;
        haltOnThrow = config.getStringArray("vm.halt_on_throw");
        porInEffect = config.getBoolean("vm.por");
        porFieldBoundaries = porInEffect && config.getBoolean("vm.por.field_boundaries");
        porSyncDetection = porInEffect && config.getBoolean("vm.por.sync_detection");
        checkBudgetCount = config.getInt("vm.budget.check_count", 9999);
        threadInfos = new SparseObjVector();
        return true;
    }

    public ThreadInfo(JVM vm, int objRef) {
        this.init(vm, objRef);
        this.env = new MJIEnv(this);
        if (mainThread == null) {
            mainThread = this;
            currentThread = this;
        }
    }

    public static ThreadInfo getMainThread() {
        return mainThread;
    }

    private void init(JVM vm, int objRef) {
        DynamicArea da = vm.getDynamicArea();
        Object ei = da.get(objRef);
        this.vm = vm;
        this.threadData = new ThreadData();
        this.threadData.status = 0;
        this.threadData.ci = ((ElementInfo)ei).getClassInfo();
        this.threadData.objref = objRef;
        this.threadData.target = -1;
        this.threadData.lockCount = 0;
        this.stack.clear();
        this.top = null;
        this.topIdx = -1;
        this.lockedObjects = new LinkedList();
        this.markUnchanged();
        this.tdChanged = true;
    }

    static ThreadInfo createThreadInfo(JVM vm, int objRef) {
        ThreadInfo ti = threadInfos.get(objRef);
        if (ti == null) {
            ti = new ThreadInfo(vm, objRef);
            threadInfos.set(objRef, ti);
        } else {
            ti.init(vm, objRef);
        }
        vm.addThread(ti);
        return ti;
    }

    static ThreadInfo getThreadInfo(JVM vm, int objRef) {
        return threadInfos.get(objRef);
    }

    public static ThreadInfo getCurrentThread() {
        return currentThread;
    }

    public boolean isExecutingAtomically() {
        return this.vm.getSystemState().isAtomic();
    }

    public boolean holdsLock(ElementInfo ei) {
        return this.lockedObjects.contains(ei);
    }

    public JVM getVM() {
        return this.vm;
    }

    public boolean isFirstStepInsn() {
        return this.isFirstStepInsn;
    }

    public boolean usePor() {
        return porInEffect;
    }

    public boolean usePorFieldBoundaries() {
        return porFieldBoundaries;
    }

    public boolean usePorSyncDetection() {
        return porSyncDetection;
    }

    void setListInfo(ThreadList tl, int idx) {
        this.list = tl;
        this.index = idx;
    }

    public boolean isAbstractionNonDeterministic() {
        if (this.getPC() == null) {
            return false;
        }
        return this.getPC().examineAbstraction(this.vm.getSystemState(), this.vm.getKernelState(), this);
    }

    public boolean isRunnable() {
        switch (this.threadData.status) {
            case 1: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public boolean willBeRunnable() {
        switch (this.threadData.status) {
            case 1: 
            case 3: {
                return true;
            }
            case 5: {
                return true;
            }
        }
        return false;
    }

    public boolean isNew() {
        return this.threadData.status == 0;
    }

    public boolean isTimeoutRunnable() {
        switch (this.threadData.status) {
            case 1: 
            case 3: {
                return true;
            }
            case 5: {
                assert (this.lockRef != -1) : "timeout waiting but no blocked object";
                Object ei = this.vm.getDynamicArea().get(this.lockRef);
                return ((ElementInfo)ei).canLock(this);
            }
        }
        return false;
    }

    public boolean isTimedOut() {
        return this.threadData.status == 8;
    }

    public boolean isTimeoutWaiting() {
        return this.threadData.status == 5;
    }

    public void setTimedOut() {
        this.setStatus(8);
    }

    public void setTerminated() {
        this.setStatus(9);
    }

    public void resetTimedOut() {
        this.setStatus(5);
    }

    public boolean isAlive() {
        return this.threadData.status != 9 && this.threadData.status != 0;
    }

    public boolean isWaiting() {
        int state = this.threadData.status;
        return state == 4 || state == 5;
    }

    public boolean isNotified() {
        return this.threadData.status == 6;
    }

    public boolean isTimedout() {
        return this.threadData.status == 8;
    }

    public boolean isUnblocked() {
        int state = this.threadData.status;
        return state == 3 || state == 8;
    }

    public boolean isBlocked() {
        return this.threadData.status == 2;
    }

    public boolean isTerminated() {
        return this.threadData.status == 9;
    }

    MethodInfo getExitMethod() {
        MethodInfo mi = this.getClassInfo().getMethod("exit()V", true);
        return mi;
    }

    public boolean isBlockedOrNotified() {
        int state = this.threadData.status;
        return state == 2 || state == 6;
    }

    public boolean getBooleanLocal(String lname) {
        return Types.intToBoolean(this.getLocalVariable(lname));
    }

    public boolean getBooleanLocal(int lindex) {
        return Types.intToBoolean(this.getLocalVariable(lindex));
    }

    public boolean getBooleanLocal(int fr, String lname) {
        return Types.intToBoolean(this.getLocalVariable(fr, lname));
    }

    public boolean getBooleanLocal(int fr, int lindex) {
        return Types.intToBoolean(this.getLocalVariable(fr, lindex));
    }

    public boolean getBooleanReturnValue() {
        return Types.intToBoolean(this.peek());
    }

    public byte getByteLocal(String lname) {
        return (byte)this.getLocalVariable(lname);
    }

    public byte getByteLocal(int lindex) {
        return (byte)this.getLocalVariable(lindex);
    }

    public byte getByteLocal(int fr, String lname) {
        return (byte)this.getLocalVariable(fr, lname);
    }

    public byte getByteLocal(int fr, int lindex) {
        return (byte)this.getLocalVariable(fr, lindex);
    }

    public byte getByteReturnValue() {
        return (byte)this.peek();
    }

    public List<StackFrame> getStack() {
        return this.stack;
    }

    public int getStackDepth() {
        return this.stack.size();
    }

    public StackFrame getStackFrame(int idx) {
        return this.stack.get(idx);
    }

    public String getCallStackClass(int i) {
        if (i < this.stack.size()) {
            return this.frame(i).getClassName();
        }
        return null;
    }

    public int getCalleeThis(MethodInfo mi) {
        return this.top.getCalleeThis(mi);
    }

    public int getCalleeThis(int size) {
        return this.top.getCalleeThis(size);
    }

    public ClassInfo getClassInfo(int objref) {
        return this.env.getClassInfo(objref);
    }

    public boolean isCalleeThis(ElementInfo r) {
        if (this.top == null || r == null) {
            return false;
        }
        Instruction pc = this.getPC();
        if (pc == null || !(pc instanceof InvokeInstruction) || pc instanceof INVOKESTATIC) {
            return false;
        }
        InvokeInstruction call = (InvokeInstruction)pc;
        return this.getCalleeThis(Types.getArgumentsSize(call.getInvokedMethodSignature()) + 1) == r.getIndex();
    }

    public char getCharLocal(String lname) {
        return (char)this.getLocalVariable(lname);
    }

    public char getCharLocal(int lindex) {
        return (char)this.getLocalVariable(lindex);
    }

    public char getCharLocal(int fr, String lname) {
        return (char)this.getLocalVariable(fr, lname);
    }

    public char getCharLocal(int fr, int lindex) {
        return (char)this.getLocalVariable(fr, lindex);
    }

    public char getCharReturnValue() {
        return (char)this.peek();
    }

    public ClassInfo getClassInfo() {
        return this.threadData.ci;
    }

    public double getDoubleLocal(String lname) {
        return Types.longToDouble(this.getLongLocalVariable(lname));
    }

    public double getDoubleLocal(int lindex) {
        return Types.longToDouble(this.getLongLocalVariable(lindex));
    }

    public double getDoubleLocal(int fr, String lname) {
        return Types.longToDouble(this.getLongLocalVariable(fr, lname));
    }

    public double getDoubleLocal(int fr, int lindex) {
        return Types.longToDouble(this.getLongLocalVariable(fr, lindex));
    }

    public double getDoubleReturnValue() {
        return Types.longToDouble(this.longPeek());
    }

    public MJIEnv getEnv() {
        return this.env;
    }

    public float getFloatLocal(String lname) {
        return Types.intToFloat(this.getLocalVariable(lname));
    }

    public float getFloatLocal(int lindex) {
        return Types.intToFloat(this.getLocalVariable(lindex));
    }

    public float getFloatLocal(int fr, String lname) {
        return Types.intToFloat(this.getLocalVariable(fr, lname));
    }

    public float getFloatLocal(int fr, int lindex) {
        return Types.intToFloat(this.getLocalVariable(fr, lindex));
    }

    public float getFloatReturnValue() {
        return Types.intToFloat(this.peek());
    }

    public int getIntLocal(String lname) {
        return this.getLocalVariable(lname);
    }

    public int getIntLocal(int lindex) {
        return this.getLocalVariable(lindex);
    }

    public int getIntLocal(int fr, String lname) {
        return this.getLocalVariable(fr, lname);
    }

    public int getIntLocal(int fr, int lindex) {
        return this.getLocalVariable(fr, lindex);
    }

    public int getIntReturnValue() {
        return this.peek();
    }

    public boolean isInterrupted(boolean resetStatus) {
        ElementInfo ei = this.getElementInfo(this.getThreadObjectRef());
        boolean status = ei.getBooleanField("interrupted");
        if (resetStatus && status) {
            ei.setBooleanField("interrupted", false);
        }
        return status;
    }

    public int getIndex() {
        return this.index;
    }

    void setLockRef(int objref) {
        assert (this.lockRef == -1 || this.lockRef == objref) : "attempt to overwrite lockRef: " + this.vm.getDynamicArea().get(this.lockRef) + " with: " + this.vm.getDynamicArea().get(objref);
        this.lockRef = objref;
    }

    public void resetLockRef() {
        this.lockRef = -1;
    }

    public ElementInfo getLockObject() {
        if (this.lockRef == -1) {
            return null;
        }
        return this.vm.getDynamicArea().get(this.lockRef);
    }

    public int getLine() {
        if (this.top == null) {
            return -1;
        }
        return this.top.getLine();
    }

    public int getLine(int idx) {
        return this.frame(idx).getLine();
    }

    public String[] getLocalNames() {
        return this.top.getLocalVariableNames();
    }

    public String[] getLocalNames(int fr) {
        return this.frame(fr).getLocalVariableNames();
    }

    public void setLocalVariable(int idx, int v, boolean ref) {
        this.topClone().setLocalVariable(idx, v, ref);
    }

    public int getLocalVariable(int fr, int idx) {
        return this.frame(fr).getLocalVariable(idx);
    }

    public int getLocalVariable(int idx) {
        return this.top.getLocalVariable(idx);
    }

    public int getLocalVariable(int fr, String name) {
        return this.frame(fr).getLocalVariable(name);
    }

    public int getLocalVariable(String name) {
        return this.top.getLocalVariable(name);
    }

    public boolean isLocalVariableRef(int idx) {
        return this.top.isLocalVariableRef(idx);
    }

    public String getLocalVariableType(int fr, String name) {
        return this.frame(fr).getLocalVariableType(name);
    }

    public String getLocalVariableType(String name) {
        return this.top.getLocalVariableType(name);
    }

    public void setLockCount(int l) {
        if (this.threadData.lockCount != l) {
            this.threadDataClone().lockCount = l;
        }
    }

    public int getLockCount() {
        return this.threadData.lockCount;
    }

    public LinkedList<ElementInfo> getLockedObjects() {
        return this.lockedObjects;
    }

    public int[] getLockedObjectReferences() {
        int[] a = new int[this.lockedObjects.size()];
        int i = 0;
        for (ElementInfo e : this.lockedObjects) {
            a[i++] = e.getIndex();
        }
        return a;
    }

    public long getLongLocal(String lname) {
        return this.getLongLocalVariable(lname);
    }

    public long getLongLocal(int lindex) {
        return this.getLongLocalVariable(lindex);
    }

    public long getLongLocal(int fr, String lname) {
        return this.getLongLocalVariable(fr, lname);
    }

    public long getLongLocal(int fr, int lindex) {
        return this.getLongLocalVariable(fr, lindex);
    }

    public void setLongLocalVariable(int idx, long v) {
        this.topClone().setLongLocalVariable(idx, v);
    }

    public long getLongLocalVariable(int fr, int idx) {
        return this.frame(fr).getLongLocalVariable(idx);
    }

    public long getLongLocalVariable(int idx) {
        return this.top.getLongLocalVariable(idx);
    }

    public long getLongLocalVariable(int fr, String name) {
        return this.frame(fr).getLongLocalVariable(name);
    }

    public long getLongLocalVariable(String name) {
        return this.top.getLongLocalVariable(name);
    }

    public long getLongReturnValue() {
        return this.longPeek();
    }

    public MethodInfo getMethod() {
        if (this.top != null) {
            return this.top.getMethodInfo();
        }
        return null;
    }

    public boolean isInCtor() {
        MethodInfo mi = this.getMethod();
        if (mi != null) {
            return mi.isCtor();
        }
        return false;
    }

    public MethodInfo getMethod(int idx) {
        StackFrame sf = this.frame(idx);
        if (sf != null) {
            return sf.getMethodInfo();
        }
        return null;
    }

    public String getName() {
        return this.threadData.name;
    }

    public ElementInfo getObjectLocal(String lname) {
        return this.list.ks.da.get(this.getLocalVariable(lname));
    }

    public ElementInfo getObjectLocal(int lindex) {
        return this.list.ks.da.get(this.getLocalVariable(lindex));
    }

    public ElementInfo getObjectLocal(int fr, String lname) {
        return this.list.ks.da.get(this.getLocalVariable(fr, lname));
    }

    public ElementInfo getObjectLocal(int fr, int lindex) {
        return this.list.ks.da.get(this.getLocalVariable(fr, lindex));
    }

    public int getThreadObjectRef() {
        return this.threadData.objref;
    }

    public ElementInfo getObjectReturnValue() {
        return this.list.ks.da.get(this.peek());
    }

    public Object getOperandAttr() {
        return this.top.getOperandAttr();
    }

    public Object getLongOperandAttr() {
        return this.top.getLongOperandAttr();
    }

    public Object getOperandAttr(int opStackOffset) {
        return this.top.getOperandAttr(opStackOffset);
    }

    public void setOperandAttr(Object attr) {
        this.topClone().setOperandAttr(attr);
    }

    public void setLongOperandAttr(Object attr) {
        this.topClone().setLongOperandAttr(attr);
    }

    public void setOperandAttrNoClone(Object attr) {
        this.top.setOperandAttr(attr);
    }

    public void setLongOperandAttrNoClone(Object attr) {
        this.top.setLongOperandAttr(attr);
    }

    public void setLocalAttr(int localIndex, Object attr) {
        this.topClone().setLocalAttr(localIndex, attr);
    }

    public void setLocalAttrNoClone(int localIndex, Object attr) {
        this.top.setLocalAttr(localIndex, attr);
    }

    public Object getLocalAttr(int localIndex) {
        return this.top.getLocalAttr(localIndex);
    }

    public boolean isOperandRef() {
        return this.top.isOperandRef();
    }

    public boolean isOperandRef(int idx) {
        return this.top.isOperandRef(idx);
    }

    public void setPC(Instruction pc) {
        this.topClone().setPC(pc);
    }

    public void advancePC() {
        this.topClone().advancePC();
    }

    public Instruction getPC(int i) {
        return this.frame(i).getPC();
    }

    public Instruction getPC() {
        if (this.top != null) {
            return this.top.getPC();
        }
        return null;
    }

    public Instruction getNextPC() {
        return this.nextPc;
    }

    public short getShortLocal(String lname) {
        return (short)this.getLocalVariable(lname);
    }

    public short getShortLocal(int lindex) {
        return (short)this.getLocalVariable(lindex);
    }

    public short getShortLocal(int fr, String lname) {
        return (short)this.getLocalVariable(fr, lname);
    }

    public short getShortLocal(int fr, int lindex) {
        return (short)this.getLocalVariable(fr, lindex);
    }

    public short getShortReturnValue() {
        return (short)this.peek();
    }

    public String getStackTrace() {
        StringBuilder sb = new StringBuilder(256);
        for (int i = this.topIdx; i >= 0; --i) {
            ClassInfo ci;
            StackFrame sf = this.stack.get(i);
            MethodInfo mi = sf.getMethodInfo();
            if (mi.isCtor() && (ci = mi.getClassInfo()).isInstanceOf("java.lang.Throwable")) continue;
            sb.append("\tat ");
            sb.append(this.stack.get(i).getStackTraceInfo());
            sb.append('\n');
        }
        return sb.toString();
    }

    public void setStatus(int newStatus) {
        int oldStatus = this.threadData.status;
        if (oldStatus != newStatus) {
            assert (oldStatus != 9) : "can't resurrect threads";
            this.threadDataClone().status = newStatus;
            switch (newStatus) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 9: {
                    this.vm.notifyThreadTerminated(this);
                    break;
                }
                case 2: {
                    this.vm.notifyThreadBlocked(this);
                    break;
                }
                case 4: {
                    this.vm.notifyThreadWaiting(this);
                    break;
                }
                case 7: {
                    this.vm.notifyThreadInterrupted(this);
                    break;
                }
                case 6: {
                    this.vm.notifyThreadNotified(this);
                }
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("setStatus of " + this.getName() + " from " + statusName[oldStatus] + " to " + statusName[newStatus]);
            }
        }
    }

    public int getStatus() {
        return this.threadData.status;
    }

    public void dumpStoringData(IntVector v) {
    }

    public String getStringLocal(String lname) {
        return ((DynamicElementInfo)this.list.ks.da.get(this.getLocalVariable(lname))).asString();
    }

    public String getStringLocal(int lindex) {
        return ((DynamicElementInfo)this.list.ks.da.get(this.getLocalVariable(lindex))).asString();
    }

    public String getStringLocal(int fr, String lname) {
        return ((DynamicElementInfo)this.list.ks.da.get(this.getLocalVariable(fr, lname))).asString();
    }

    public String getStringLocal(int fr, int lindex) {
        return ((DynamicElementInfo)this.list.ks.da.get(this.getLocalVariable(fr, lindex))).asString();
    }

    public String getStringReturnValue() {
        return ((DynamicElementInfo)this.list.ks.da.get(this.peek())).asString();
    }

    public void setTarget(int t) {
        if (this.threadData.target != t) {
            this.threadDataClone().target = t;
        }
    }

    public int getTarget() {
        return this.threadData.target;
    }

    public int getThis() {
        return this.top.getThis();
    }

    public boolean isThis(ElementInfo r) {
        if (r == null) {
            return false;
        }
        if (this.top == null) {
            return false;
        }
        return this.getMethod().isStatic() ? false : r.getIndex() == this.getLocalVariable(0);
    }

    public boolean atMethod(String mname) {
        return this.top != null && this.getMethod().getCompleteName().equals(mname);
    }

    public boolean atPosition(int position) {
        if (this.top == null) {
            return false;
        }
        Instruction pc = this.getPC();
        return pc != null && pc.getPosition() == position;
    }

    public boolean atReturn() {
        if (this.top == null) {
            return false;
        }
        Instruction pc = this.getPC();
        return pc instanceof ReturnInstruction;
    }

    void resetVolatiles() {
        this.lockedObjects = new LinkedList();
        this.lockRef = -1;
    }

    void addLockedObject(ElementInfo ei) {
        this.lockedObjects.add(ei);
        this.vm.notifyObjectLocked(this, ei);
    }

    void removeLockedObject(ElementInfo ei) {
        this.lockedObjects.remove(ei);
        this.vm.notifyObjectUnlocked(this, ei);
    }

    public void callerPop(int n) {
        this.frameClone(-1).pop(n);
    }

    public void clearOperandStack() {
        this.topClone().clearOperandStack();
    }

    public Object clone() {
        try {
            ThreadInfo other = (ThreadInfo)super.clone();
            other.stack = this.cloneStack();
            other.lockedObjects = this.cloneLockedObjects();
            return other;
        }
        catch (CloneNotSupportedException cnsx) {
            return null;
        }
    }

    LinkedList<ElementInfo> cloneLockedObjects() {
        LinkedList<ElementInfo> lo = new LinkedList<ElementInfo>();
        for (ElementInfo ei : this.lockedObjects) {
            lo.add((ElementInfo)ei.clone());
        }
        return lo;
    }

    ArrayList<StackFrame> cloneStack() {
        ArrayList<StackFrame> sf = new ArrayList<StackFrame>(this.stack.size());
        for (StackFrame f : this.stack) {
            sf.add(f.clone());
        }
        return sf;
    }

    public StackFrame[] dumpStack() {
        return this.stack.toArray(new StackFrame[this.stack.size()]);
    }

    public int countStackFrames() {
        return this.stack.size();
    }

    int countVisibleStackFrames() {
        int n = 0;
        int len = this.stack.size();
        for (int i = 0; i < len; ++i) {
            if (this.stack.get(i).isDirectCallFrame()) continue;
            ++n;
        }
        return n;
    }

    public int[] getSnapshot(int xObjRef) {
        int[] snap;
        int n = this.stack.size();
        if (xObjRef != -1) {
            for (int i = n - 1; i >= 0 && this.stack.get(i).getThis() == xObjRef; --i) {
                --n;
            }
        }
        int j = 0;
        MethodInfo nativeMth = this.env.getMethodInfo();
        if (nativeMth != null && n == this.stack.size()) {
            snap = new int[n * 2 + 2];
            snap[j++] = nativeMth.getGlobalId();
            snap[j++] = -1;
        } else {
            snap = new int[n * 2];
        }
        for (int i = n - 1; i >= 0; --i) {
            StackFrame frame = this.stack.get(i);
            snap[j++] = frame.getMethodInfo().getGlobalId();
            snap[j++] = frame.getPC().getOffset();
        }
        return snap;
    }

    public int createStackTraceElements(int[] snapshot) {
        int n = snapshot.length / 2;
        DynamicArea da = DynamicArea.getHeap();
        int aref = da.newArray("Ljava/lang/StackTraceElement;", n, this);
        Object aei = da.get(aref);
        int j = 0;
        for (int i = 0; i < n; ++i) {
            StackTraceElement ste = new StackTraceElement(MethodInfo.getMethodInfo(snapshot[j++]), snapshot[j++]);
            int eref = ste.createJPFStackTraceElement();
            ((ElementInfo)aei).setElement(i, eref);
        }
        return aref;
    }

    void print(PrintWriter pw, String s) {
        if (pw != null) {
            pw.print(s);
        } else {
            this.vm.print(s);
        }
    }

    public void printStackTrace(int objRef) {
        this.printStackTrace(null, objRef);
    }

    public void printPendingExceptionOn(PrintWriter pw) {
        if (this.pendingException != null) {
            this.printStackTrace(pw, this.pendingException.getExceptionReference());
        }
    }

    public void printStackTrace(PrintWriter pw, int objRef) {
        int causeRef;
        this.print(pw, this.env.getClassInfo(objRef).getName());
        int msgRef = this.env.getReferenceField(objRef, "detailMessage");
        if (msgRef != -1) {
            this.print(pw, ": ");
            this.print(pw, this.env.getStringObject(msgRef));
        }
        this.print(pw, "\n");
        int aRef = this.env.getReferenceField(objRef, "stackTrace");
        if (aRef != -1) {
            int len = this.env.getArrayLength(aRef);
            for (int i = 0; i < len; ++i) {
                StackTraceElement ste = new StackTraceElement(this.env.getReferenceArrayElement(aRef, i));
                ste.printOn(pw);
            }
        } else {
            aRef = this.env.getReferenceField(objRef, "snapshot");
            int[] snapshot = this.env.getIntArrayObject(aRef);
            int len = snapshot.length / 2;
            int j = 0;
            for (int i = 0; i < len; ++i) {
                StackTraceElement ste = new StackTraceElement(MethodInfo.getMethodInfo(snapshot[j++]), snapshot[j++]);
                ste.printOn(pw);
            }
        }
        if ((causeRef = this.env.getReferenceField(objRef, "cause")) != objRef && causeRef != -1) {
            this.print(pw, "Caused by: ");
            this.printStackTrace(pw, causeRef);
        }
    }

    int createException(ClassInfo ci, String details, int causeRef) {
        DynamicArea da = DynamicArea.getHeap();
        int objref = da.newObject(ci, this);
        int msgref = -1;
        if (!ci.isInitialized()) {
            ci.loadAndInitialize(this);
        }
        Object ei = da.get(objref);
        if (details != null) {
            msgref = da.newString(details, this);
            ((ElementInfo)ei).setReferenceField("detailMessage", msgref);
        }
        int[] snap = this.getSnapshot(-1);
        int aref = this.env.newIntArray(snap);
        ((ElementInfo)ei).setReferenceField("snapshot", aref);
        ((ElementInfo)ei).setReferenceField("cause", causeRef != -1 ? causeRef : objref);
        return objref;
    }

    public Instruction createAndThrowException(ClassInfo ci, String details) {
        int objref = this.createException(ci, details, -1);
        return this.throwException(objref);
    }

    public Instruction createAndThrowException(String cname) {
        return this.createAndThrowException(ClassInfo.getClassInfo(cname), null);
    }

    public Instruction createAndThrowException(String cname, String details) {
        return this.createAndThrowException(ClassInfo.getClassInfo(cname), details);
    }

    public void dup() {
        this.topClone().dup();
    }

    public void dup2() {
        this.topClone().dup2();
    }

    public void dup2_x1() {
        this.topClone().dup2_x1();
    }

    public void dup2_x2() {
        this.topClone().dup2_x2();
    }

    public void dup_x1() {
        this.topClone().dup_x1();
    }

    public void dup_x2() {
        this.topClone().dup_x2();
    }

    public void skipInstructionLogging() {
        this.logInstruction = false;
    }

    public Instruction executeInstruction() {
        Instruction pc = this.getPC();
        SystemState ss = this.vm.getSystemState();
        KernelState ks = this.vm.getKernelState();
        this.logInstruction = true;
        this.skipInstruction = false;
        this.nextPc = null;
        MethodInfo mth = this.getMethod();
        if (log.isLoggable(Level.FINE)) {
            log.fine(pc.getMethodInfo().getCompleteName() + " " + pc.getPosition() + " : " + pc);
        }
        this.vm.notifyExecuteInstruction(this, pc);
        if (!this.skipInstruction) {
            this.nextPc = pc.execute(ss, ks, this);
        }
        if (this.logInstruction) {
            ss.recordExecutionStep(mth, pc);
        }
        if (this.top != null) {
            this.setPC(this.nextPc);
        }
        this.vm.notifyInstructionExecuted(this, pc, this.nextPc);
        return this.nextPc;
    }

    public Instruction executeInstructionHidden() {
        Instruction pc = this.getPC();
        SystemState ss = this.vm.getSystemState();
        KernelState ks = this.vm.getKernelState();
        if (log.isLoggable(Level.FINE)) {
            log.fine(pc.getMethodInfo().getCompleteName() + " " + pc.getPosition() + " : " + pc);
        }
        this.nextPc = pc.execute(ss, ks, this);
        if (this.top != null) {
            this.setPC(this.nextPc);
        }
        return this.nextPc;
    }

    public boolean isPostExec() {
        return this.nextPc != null;
    }

    public void skipInstruction() {
        this.skipInstruction = true;
    }

    public boolean isInstructionSkipped() {
        return this.skipInstruction;
    }

    public void setNextPC(Instruction insn) {
        this.nextPc = insn;
    }

    public void executeMethodAtomic(DirectCallStackFrame frame) {
        this.pushFrame(frame);
        int depth = this.countStackFrames();
        Instruction pc = frame.getPC();
        frame.getMethodInfo().enter(this);
        Verify.beginAtomic();
        while (depth <= this.countStackFrames()) {
            Instruction nextPC = this.executeInstruction();
            if (nextPC == pc) {
                throw new JPFException("choice point in atomic method execution: " + frame);
            }
            pc = nextPC;
        }
        Verify.endAtomic();
    }

    public void executeMethodHidden(DirectCallStackFrame frame) {
        this.pushFrame(frame);
        int depth = this.countStackFrames();
        Instruction pc = frame.getPC();
        frame.getMethodInfo().enter(this);
        Verify.beginAtomic();
        while (depth <= this.countStackFrames()) {
            Instruction nextPC = this.executeInstructionHidden();
            if (this.pendingException != null) continue;
            if (nextPC == pc) {
                throw new JPFException("choice point in hidden method execution: " + frame);
            }
            pc = nextPC;
        }
        Verify.endAtomic();
    }

    public ElementInfo getElementInfo(int ref) {
        DynamicArea da = this.vm.getDynamicArea();
        return da.get(ref);
    }

    public void finish() {
        this.setStatus(9);
        int objref = this.getThreadObjectRef();
        ElementInfo ei = this.getElementInfo(objref);
        this.cleanupThreadObject(ei);
        this.vm.activateGC();
    }

    void cleanupThreadObject(ElementInfo ei) {
        int grpRef = ei.getReferenceField("group");
        this.cleanupThreadGroup(grpRef, ei.getIndex());
        ei.setReferenceField("group", -1);
        ei.setReferenceField("threadLocals", -1);
        ei.setReferenceField("inheritableThreadLocals", -1);
    }

    void cleanupThreadGroup(int grpRef, int threadRef) {
        ElementInfo eiThreads;
        ElementInfo eiGrp;
        int threadsRef;
        if (grpRef != -1 && (threadsRef = (eiGrp = this.getElementInfo(grpRef)).getReferenceField("threads")) != -1 && (eiThreads = this.getElementInfo(threadsRef)).isArray()) {
            int nthreads = eiGrp.getIntField("nthreads");
            for (int i = 0; i < nthreads; ++i) {
                int tref = eiThreads.getElement(i);
                if (tref != threadRef) continue;
                int n1 = nthreads - 1;
                for (int j = i; j < n1; ++j) {
                    eiThreads.setElement(j, eiThreads.getElement(j + 1));
                }
                eiThreads.setElement(n1, -1);
                eiGrp.setIntField("nthreads", n1);
                if (n1 == 0) {
                    eiGrp.lock(this);
                    eiGrp.notifiesAll();
                    eiGrp.unlock(this);
                }
                return;
            }
        }
    }

    public void hash(HashData hd) {
        this.threadData.hash(hd);
        int l = this.stack.size();
        for (int i = 0; i < l; ++i) {
            this.stack.get(i).hash(hd);
        }
    }

    public void interrupt() {
        ElementInfo eiThread = this.getElementInfo(this.getThreadObjectRef());
        int status = this.getStatus();
        switch (status) {
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                eiThread.setBooleanField("interrupted", true);
                break;
            }
            case 4: 
            case 5: {
                eiThread.setBooleanField("interrupted", true);
                this.setStatus(7);
                Object eiLock = this.list.ks.da.get(this.lockRef);
                if (!((ElementInfo)eiLock).canLock(this)) break;
                this.setStatus(3);
                break;
            }
            case 0: 
            case 9: {
                break;
            }
        }
    }

    public long longPeek() {
        return this.top.longPeek();
    }

    public long longPeek(int n) {
        return this.top.longPeek(n);
    }

    public long longPop() {
        return this.topClone().longPop();
    }

    public void longPush(long v) {
        this.topClone().longPush(v);
    }

    void markRoots() {
        DynamicArea heap = DynamicArea.getHeap();
        heap.markThreadRoot(this.threadData.objref, this.index);
        if (this.threadData.target != -1) {
            heap.markThreadRoot(this.threadData.target, this.index);
        }
        int l = this.stack.size();
        for (int i = 0; i < l; ++i) {
            this.stack.get(i).markThreadRoots(this.index);
        }
    }

    public void pushFrame(StackFrame frame) {
        this.topIdx = this.stack.size();
        this.stack.add(frame);
        this.top = frame;
        this.markChanged(this.topIdx);
    }

    public int peek() {
        if (this.top != null) {
            return this.top.peek();
        }
        return -1;
    }

    public int peek(int n) {
        if (this.top != null) {
            return this.top.peek(n);
        }
        return -1;
    }

    public int pop() {
        if (this.top != null) {
            return this.topClone().pop();
        }
        return -1;
    }

    public void pop(int n) {
        if (this.top != null) {
            this.topClone().pop(n);
        }
    }

    public boolean popFrame() {
        if (this.top.hasAnyRef()) {
            this.vm.getSystemState().activateGC();
        }
        this.returnedDirectCall = this.top instanceof DirectCallStackFrame ? (DirectCallStackFrame)this.top : null;
        this.stack.remove(this.topIdx);
        this.markChanged(this.topIdx);
        --this.topIdx;
        if (this.topIdx >= 0) {
            this.top = this.stack.get(this.topIdx);
            return true;
        }
        this.top = null;
        return false;
    }

    public Instruction getReturnFollowOnPC() {
        if (this.returnedDirectCall != null) {
            Instruction next = this.returnedDirectCall.getNextPC();
            if (next != null) {
                return next;
            }
            return this.top.getPC();
        }
        return this.top.getPC().getNext();
    }

    public boolean isResumedInstruction(Instruction insn) {
        return this.returnedDirectCall != null && this.returnedDirectCall.getNextPC() == insn;
    }

    public DirectCallStackFrame getReturnedDirectCall() {
        return this.returnedDirectCall;
    }

    public String getStateDescription() {
        StringBuilder sb = new StringBuilder("thread index=");
        sb.append(this.index);
        sb.append(',');
        sb.append(this.threadData.getFieldValues());
        return sb.toString();
    }

    public String getStatusName() {
        return statusName[this.getStatus()];
    }

    public void printStackContent() {
        for (int i = this.topIdx; i >= 0; --i) {
            this.stack.get(i).printStackContent();
        }
    }

    public void printStackTrace() {
        for (int i = this.topIdx; i >= 0; --i) {
            this.stack.get(i).printStackTrace();
        }
    }

    public void push(int v, boolean ref) {
        this.topClone().push(v, ref);
    }

    public void pushLocal(int localIndex) {
        this.topClone().pushLocal(localIndex);
    }

    public void pushLongLocal(int localIndex) {
        this.topClone().pushLongLocal(localIndex);
    }

    public void storeOperand(int localIndex) {
        this.topClone().storeOperand(localIndex);
    }

    public void storeLongOperand(int localIndex) {
        this.topClone().storeLongOperand(localIndex);
    }

    public void removeArguments(MethodInfo mi) {
        int i = mi.getArgumentsSize();
        if (i != 0) {
            this.pop(i);
        }
    }

    public void swap() {
        this.topClone().swap();
    }

    boolean haltOnThrow(String exceptionClassName) {
        if (haltOnThrow != null && haltOnThrow.length > 0) {
            for (String s : haltOnThrow) {
                if (!s.equalsIgnoreCase("any") && !exceptionClassName.startsWith(s)) continue;
                return true;
            }
        }
        return false;
    }

    public Instruction throwException(int exceptionObjRef) {
        DynamicArea da = DynamicArea.getHeap();
        Object ei = da.get(exceptionObjRef);
        ClassInfo ci = ((ElementInfo)ei).getClassInfo();
        String cname = ci.getName();
        int nFrames = this.countStackFrames();
        Instruction insn = this.vm.handleException(this, exceptionObjRef);
        if (insn != null) {
            return insn;
        }
        this.pendingException = new ExceptionInfo(this, (ElementInfo)ei);
        this.vm.notifyExceptionThrown(this, (ElementInfo)ei);
        if (!this.haltOnThrow(cname)) {
            for (int j = 0; j < nFrames; ++j) {
                ExceptionHandler[] exceptions;
                MethodInfo mi = this.getMethod();
                insn = this.getPC();
                if (mi.isReflectionCallStub()) {
                    String details = ci.getName();
                    ci = ClassInfo.getClassInfo("java.lang.reflect.InvocationTargetException");
                    exceptionObjRef = this.createException(ci, details, exceptionObjRef);
                }
                if ((exceptions = mi.getExceptions()) != null) {
                    int p = insn.getPosition();
                    for (int i = 0; i < exceptions.length; ++i) {
                        String en;
                        ExceptionHandler eh = exceptions[i];
                        if (p < eh.getBegin() || p >= eh.getEnd() || (en = eh.getName()) != null && !ci.isInstanceOf(en)) continue;
                        int handlerOffset = eh.getHandler();
                        this.clearOperandStack();
                        this.push(exceptionObjRef, true);
                        Instruction startOfHandlerBlock = mi.getInstructionAt(handlerOffset);
                        this.setPC(startOfHandlerBlock);
                        this.pendingException = null;
                        return startOfHandlerBlock;
                    }
                }
                if (mi.isFirewall()) break;
                mi.leave(this);
                this.popFrame();
            }
        }
        NoUncaughtExceptionsProperty.setExceptionInfo(this.pendingException);
        throw new UncaughtException(this, exceptionObjRef);
    }

    public void dropFrame() {
        MethodInfo mi = this.getMethod();
        mi.leave(this);
        this.popFrame();
    }

    public ExceptionInfo getPendingException() {
        return this.pendingException;
    }

    public void clearPendingException() {
        NoUncaughtExceptionsProperty.setExceptionInfo(null);
        this.pendingException = null;
    }

    public void replaceStackFrames(Iterable<StackFrame> iter) {
        this.stack.clear();
        for (StackFrame sf : iter) {
            this.stack.add(sf);
        }
        this.topIdx = this.stack.size() - 1;
        this.top = this.topIdx >= 0 ? this.stack.get(this.topIdx) : null;
    }

    protected ThreadData threadDataClone() {
        if (!this.tdChanged) {
            this.markTdChanged();
            this.list.ks.changed();
            this.threadData = this.threadData.clone();
        }
        return this.threadData;
    }

    public void restoreThreadData(ThreadData td) {
        this.threadData = td;
    }

    protected boolean executeStep(SystemState ss) throws JPFException {
        Instruction pc = this.getPC();
        Instruction nextPc = null;
        if (currentThread != this) {
            this.vm.notifyThreadScheduled(this);
            currentThread = this;
        }
        boolean nExec = false;
        this.isFirstStepInsn = true;
        do {
            nextPc = this.executeInstruction();
            if (ss.breakTransition()) break;
            pc = nextPc;
            this.isFirstStepInsn = false;
        } while (pc != null);
        return true;
    }

    public void reschedule(boolean forceBreak) {
        ThreadInfo[] runnables = this.list.getRunnableThreads();
        if (forceBreak || runnables.length > 1) {
            ThreadChoiceFromSet cg = new ThreadChoiceFromSet(runnables, true);
            SystemState ss = this.vm.getSystemState();
            ss.setNextChoiceGenerator(cg);
        }
    }

    public void breakTransition() {
        BreakGenerator cg = new BreakGenerator(this, false);
        SystemState ss = this.vm.getSystemState();
        ss.setNextChoiceGenerator(cg);
    }

    public boolean checkPorFieldBoundary() {
        return this.isFirstStepInsn && porFieldBoundaries && this.list.hasOtherRunnablesThan(this);
    }

    public boolean hasOtherRunnables() {
        return this.list.hasOtherRunnablesThan(this);
    }

    protected void markUnchanged() {
        this.hasChanged.clear();
        this.tdChanged = false;
    }

    protected void markChanged(int idx) {
        this.hasChanged.set(idx);
        this.list.ks.changed();
    }

    protected void markTdChanged() {
        this.tdChanged = true;
        this.list.ks.changed();
    }

    protected StackFrame frame(int idx) {
        if (idx < 0) {
            idx += this.topIdx;
        }
        return this.stack.get(idx);
    }

    public StackFrame getCallerStackFrame() {
        if (this.topIdx <= 0) {
            return null;
        }
        return this.stack.get(this.topIdx - 1);
    }

    protected StackFrame frameClone(int i) {
        if (i < 0) {
            i += this.topIdx;
        } else if (i == this.topIdx) {
            return this.topClone();
        }
        if (this.hasChanged.get(i)) {
            return this.stack.get(i);
        }
        this.markChanged(i);
        StackFrame clone = this.stack.get(i).clone();
        this.stack.set(i, clone);
        return clone;
    }

    protected StackFrame topClone() {
        if (!this.hasChanged.get(this.topIdx)) {
            this.markChanged(this.topIdx);
            this.top = this.top.clone();
            this.stack.set(this.topIdx, this.top);
        }
        return this.top;
    }

    public StackFrame getTopFrame() {
        return this.top;
    }

    public StackFrame getStackFrameExecuting(Instruction insn) {
        for (int i = this.topIdx; i >= 0; --i) {
            StackFrame f = this.stack.get(i);
            if (f.getPC() != insn) continue;
            return f;
        }
        return null;
    }

    public String toString() {
        return "ThreadInfo [name=" + this.getName() + ",index=" + this.index + ']';
    }

    void setDaemon(boolean isDaemon) {
        this.threadDataClone().isDaemon = isDaemon;
    }

    boolean isDaemon() {
        return this.threadData.isDaemon;
    }

    MJIEnv getMJIEnv() {
        return this.env;
    }

    void setName(String newName) {
        this.threadDataClone().name = newName;
    }

    void setPriority(int newPrio) {
        if (this.threadData.priority != newPrio) {
            this.threadDataClone().priority = newPrio;
        }
    }

    int getPriority() {
        return this.threadData.priority;
    }

    void init(int rGroup, int rRunnable, int rName, long stackSize, boolean setPriority) {
        DynamicArea da = JVM.getVM().getDynamicArea();
        Object ei = da.get(rName);
        this.threadDataClone();
        this.threadData.name = ((ElementInfo)ei).asString();
        this.threadData.target = rRunnable;
    }

    @Override
    public Iterator<StackFrame> iterator() {
        return this.stack.iterator();
    }

    @Override
    public int compareTo(ThreadInfo that) {
        return this.index - that.index;
    }

    class StackTraceElement {
        String clsName;
        String mthName;
        String fileName;
        int line;
        boolean ignore;

        StackTraceElement(MethodInfo mi, int pcOffset) {
            if (mi.isDirectCallStub()) {
                if (mi.isReflectionCallStub()) {
                    this.clsName = "java.lang.reflect.Method";
                    this.mthName = "invoke";
                    this.fileName = "Native Method";
                    this.line = -1;
                } else {
                    this.ignore = true;
                }
            } else {
                this.clsName = mi.getClassName();
                this.mthName = mi.getName();
                if (mi.isMJI()) {
                    this.fileName = "Native Method";
                    this.line = -1;
                } else {
                    this.fileName = mi.getSourceFileName();
                    this.line = mi.getLineNumber(mi.getInstruction(pcOffset));
                }
            }
        }

        StackTraceElement(int sRef) {
            this.clsName = ThreadInfo.this.env.getStringObject(ThreadInfo.this.env.getReferenceField(sRef, "clsName"));
            this.mthName = ThreadInfo.this.env.getStringObject(ThreadInfo.this.env.getReferenceField(sRef, "mthName"));
            this.fileName = ThreadInfo.this.env.getStringObject(ThreadInfo.this.env.getReferenceField(sRef, "fileName"));
            this.line = ThreadInfo.this.env.getIntField(sRef, "line");
        }

        int createJPFStackTraceElement() {
            if (this.ignore) {
                return -1;
            }
            DynamicArea da = DynamicArea.getHeap();
            ClassInfo ci = ClassInfo.getClassInfo("java.lang.StackTraceElement");
            int sRef = da.newObject(ci, ThreadInfo.this);
            Object sei = da.get(sRef);
            ((ElementInfo)sei).setReferenceField("clsName", da.newString(this.clsName, ThreadInfo.this));
            ((ElementInfo)sei).setReferenceField("mthName", da.newString(this.mthName, ThreadInfo.this));
            ((ElementInfo)sei).setReferenceField("fileName", da.newString(this.fileName, ThreadInfo.this));
            ((ElementInfo)sei).setIntField("line", this.line);
            return sRef;
        }

        void printOn(PrintWriter pw) {
            if (!this.ignore) {
                int idx;
                if (this.fileName != null && (idx = this.fileName.lastIndexOf(File.separatorChar)) >= 0) {
                    this.fileName = this.fileName.substring(idx + 1);
                }
                ThreadInfo.this.print(pw, "\tat ");
                ThreadInfo.this.print(pw, this.clsName);
                ThreadInfo.this.print(pw, ".");
                ThreadInfo.this.print(pw, this.mthName);
                if (this.fileName != null) {
                    ThreadInfo.this.print(pw, "(");
                    ThreadInfo.this.print(pw, this.fileName);
                    if (this.line >= 0) {
                        ThreadInfo.this.print(pw, ":");
                        ThreadInfo.this.print(pw, Integer.toString(this.line));
                    }
                    ThreadInfo.this.print(pw, ")");
                }
                ThreadInfo.this.print(pw, "\n");
            }
        }
    }
}

