/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.util.HashData;

public class ThreadData {
    int status;
    int priority = 5;
    String name = "?";
    boolean isDaemon;
    ClassInfo ci;
    int objref;
    int target = -1;
    int lockCount;

    public ThreadData clone() {
        ThreadData t = new ThreadData();
        t.status = this.status;
        t.ci = this.ci;
        t.objref = this.objref;
        t.target = this.target;
        t.lockCount = this.lockCount;
        t.priority = this.priority;
        t.name = this.name;
        t.isDaemon = this.isDaemon;
        return t;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ThreadData)) {
            return false;
        }
        ThreadData t = (ThreadData)o;
        return this.status == t.status && this.ci == t.ci && this.objref == t.objref && this.target == t.target && this.priority == t.priority && this.isDaemon == t.isDaemon && this.lockCount == t.lockCount && this.name.equals(t.name);
    }

    public void hash(HashData hd) {
        hd.add(this.status);
        hd.add(this.objref);
        hd.add(this.target);
        hd.add(this.lockCount);
        hd.add(this.priority);
        hd.add(this.isDaemon);
        hd.add(this.name);
    }

    public int hashCode() {
        HashData hd = new HashData();
        this.hash(hd);
        return hd.getValue();
    }

    public String toString() {
        return "ThreadData [" + this.getFieldValues() + "]";
    }

    public String getFieldValues() {
        DynamicArea heap = DynamicArea.getHeap();
        StringBuilder sb = new StringBuilder("name=");
        sb.append(this.name);
        sb.append(",status=");
        sb.append(ThreadInfo.statusName[this.status]);
        sb.append(",this=");
        sb.append(heap.get(this.objref));
        if (this.target != this.objref) {
            sb.append(",target=");
            sb.append(heap.get(this.target));
        }
        sb.append(",priority=");
        sb.append(this.priority);
        sb.append(",lockCount=");
        sb.append(this.lockCount);
        return sb.toString();
    }

    public int getObjRef() {
        return this.objref;
    }

    public int getStatus() {
        return this.status;
    }
}

